/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.jobwork;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundShowWorkNeedingDoneMainOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobsNeedingWorkScreen
extends Screen {
    private final HorseSimple horse;
    private final List<JobSimple> jobs;

    public static void showScreen(HorseSimple horse, List<JobSimple> jobs) {
        JobsNeedingWorkScreen screen = new JobsNeedingWorkScreen(horse, jobs);
        ScreenStack.getInstance().push(screen);
    }

    private JobsNeedingWorkScreen(HorseSimple horse, List<JobSimple> jobs) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.job-work-needing-done.menu.title", horse.name())));
        this.horse = horse;
        this.jobs = jobs;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        int x = this.f_96543_ / 2;
        int y = 35;
        for (JobSimple job : this.jobs) {
            ECButton button = ECButton.Builder.start(x, y, 150, 20).withLabel(job.name()).withOnClick(() -> {
                ServerBoundShowWorkNeedingDoneMainOpenPacket packet = new ServerBoundShowWorkNeedingDoneMainOpenPacket(this.horse.id(), job.id());
                Network.sendToServer(packet);
            }).centerAligned().complete();
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobsNeedingWorkScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

