/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.lineage;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.horse.lineage.LineageTreeNodeWidget;
import com.equestricraft.mod.horse.LineageNodeMenuItem;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundLineageMenuOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseLineageMenu
extends Screen {
    private final LineageNodeMenuItem item;
    private final List<HLine> hLines = new ArrayList<HLine>();
    private final List<VLine> vLines = new ArrayList<VLine>();

    public static void showHorseLineageMenu(LineageNodeMenuItem item) {
        HorseLineageMenu screen = new HorseLineageMenu(item);
        ScreenStack.getInstance().push(screen);
    }

    private HorseLineageMenu(LineageNodeMenuItem item) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.lineage-menu.title", item.horseName())));
        this.item = item;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addItem(this.item, 1, 0);
    }

    private void addItem(LineageNodeMenuItem itemToAdd, int level, int centerOffset) {
        int y = 25 + (level - 1) * 50;
        LineageTreeNodeWidget widget = new LineageTreeNodeWidget(this.ox(centerOffset), y, itemToAdd, i -> {
            ServerBoundLineageMenuOpenPacket packet = new ServerBoundLineageMenuOpenPacket(i.horseId());
            Network.sendToServer(packet);
        });
        this.m_142416_((GuiEventListener)widget);
        if (itemToAdd.hasParents()) {
            int nextLevel = level + 1;
            int xOffset = 90 / level;
            int nextY = 25 + (nextLevel - 1) * 50;
            VLine vLine = new VLine(this.f_96543_ / 2 + centerOffset, y, nextY);
            this.vLines.add(vLine);
            int motherCenter = centerOffset - xOffset;
            int fatherCenter = centerOffset + xOffset;
            this.addItem(itemToAdd.mother(), nextLevel, motherCenter);
            this.addItem(itemToAdd.father(), nextLevel, fatherCenter);
            HLine hLine = new HLine(this.ox(motherCenter) + 80, this.ox(fatherCenter), nextY);
            this.hLines.add(hLine);
        }
    }

    private int ox(int x) {
        return this.f_96543_ / 2 - 40 + x;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseLineageMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        for (HLine hLine : this.hLines) {
            GuiUtil.drawHorizontalLine(poseStack, hLine.x1(), hLine.x2(), hLine.y(), 1, Argb.ARGB_BLUE);
        }
        for (VLine vLine : this.vLines) {
            GuiUtil.drawVerticalLine(poseStack, vLine.x(), vLine.y1(), vLine.y2(), 1, Argb.ARGB_BLUE);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }

    private record VLine(int x, int y1, int y2) {
    }

    private record HLine(int x1, int x2, int y) {
    }
}

