/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.list;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.list.HorseListItem;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundCallHorseRequestPacket;
import com.equestricraft.mod.packet.ServerBoundHorseListSelectPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class HorseListItemWidget
extends ECWidget {
    private final ResourceLocation healthStatusIcon;
    private final HorseListItem horseListItem;
    private final ECField nameField;
    private final ECField showNameField;
    private final ECField genderField;
    private final ECField ageField;
    private final ECField ownerField;
    private final ECButton callButton;

    public HorseListItemWidget(int x, int y, int width, HorseListItem horseListItem) {
        super(x, y, width, GuiUtil.getSpacedLineHeight() + 4);
        this.horseListItem = horseListItem;
        this.healthStatusIcon = this.getIconForHealthStatus(horseListItem.horseHealth());
        this.nameField = ECField.Builder.start(this.dx(15), this.dy(4), width - 10).withValue(horseListItem.name()).withValueColor(Argb.ARGB_WHITE).complete();
        this.showNameField = ECField.Builder.start(this.dx(100), this.dy(4), width - 10).withValue(horseListItem.showName() != null ? horseListItem.showName() : "").withValueColor(Argb.ARGB_WHITE).complete();
        this.genderField = ECField.Builder.start(this.dx(260), this.dy(4), width - 10).withValue(horseListItem.gender()).withValueColor(Argb.ARGB_WHITE).complete();
        this.ageField = ECField.Builder.start(this.dx(310), this.dy(4), width - 10).withValue(horseListItem.age()).withValueColor(Argb.ARGB_WHITE).complete();
        this.ownerField = horseListItem.owner() != null ? ECField.Builder.start(this.dx(370), this.dy(2), width - 10).withLabel(I18n.getLabel("horse.list.menu.item.owned-by")).withValue(horseListItem.owner().ign()).complete() : null;
        this.callButton = ECButton.Builder.start(this.dx(width - 40), this.dy(0), 40, this.f_93619_).withLabel(I18n.getLabel("horse.list.menu.item.button.call.label")).withOnClick(() -> Network.sendToServer(new ServerBoundCallHorseRequestPacket(horseListItem.id()))).complete();
    }

    private ResourceLocation getIconForHealthStatus(HorseHealth status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case HorseHealth.GREEN -> Resources.getTextures().getGui().get("green-tick.png");
            case HorseHealth.AMBER -> Resources.getTextures().getGui().get("warning_orange.png");
            case HorseHealth.RED -> Resources.getTextures().getGui().get("warning_red.png");
        };
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, Argb.ARGB_WHITE.withTransparency(50));
        }
        GuiUtil.drawImage(poseStack, this.healthStatusIcon, this.dx(0), this.dy(0), GuiUtil.getSpacedLineHeight(), GuiUtil.getSpacedLineHeight());
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.showNameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.genderField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.ageField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.ownerField != null) {
            this.ownerField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.callButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.callButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        Network.sendToServer(new ServerBoundHorseListSelectPacket(this.horseListItem.id()));
        return true;
    }
}

