/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.list;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.list.HorseListItem;
import com.equestricraft.core.horse.list.HorseListPage;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.horse.list.HorseListItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseListRefreshPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class HorseListScreen
extends PageScreen<HorseListPage, HorseListItem, HorseListSortOrder, String> {
    public static void showScreen(HorseListPage horseListPage) {
        HorseListScreen screen = new HorseListScreen(horseListPage);
        ScreenStack.getInstance().clearAndPush(screen);
    }

    protected HorseListScreen(HorseListPage horseListPage) {
        super(I18n.getLabel("horse.list.menu.title"), horseListPage);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initSearch();
        this.initHeader();
        this.initRows();
        this.initSortOrderButton();
        this.initSortDirectionButton();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundHorseListRefreshPacket packet = new ServerBoundHorseListRefreshPacket(newPageNumber, (HorseListSortOrder)((Object)((HorseListPage)this.page).getSortOrder()), ((HorseListPage)this.page).getSortDirection(), (String)((HorseListPage)this.page).getFilterObject());
        Network.sendToServer(packet);
    }

    private void initSearch() {
        EditBox searchText = new EditBox(this.f_96547_, 5, 7, 100, 15, (Component)ComponentUtil.buildColoredTextComponent(""));
        searchText.m_94144_((String)((HorseListPage)this.page).getFilterObject());
        ECButton searchButton = ECButton.Builder.start(110, 7, 50, 15).withLabel(I18n.getLabel("horse.list.menu.search.button.label")).withOnClick(() -> {
            String text = searchText.m_94155_();
            ServerBoundHorseListRefreshPacket packet = new ServerBoundHorseListRefreshPacket(1, (HorseListSortOrder)((Object)((Object)((HorseListPage)this.page).getSortOrder())), ((HorseListPage)this.page).getSortDirection(), text);
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)searchText);
        this.m_142416_((GuiEventListener)searchButton);
    }

    private void initHeader() {
        int y = 30;
        int headerWidth = this.f_96543_ - 20;
        ECField nameLabel = ECField.Builder.start(25, y, headerWidth).withValue(I18n.getLabel("horse.list.menu.header.name")).complete();
        this.m_142416_((GuiEventListener)nameLabel);
        ECField showNameLabel = ECField.Builder.start(110, y, headerWidth).withValue(I18n.getLabel("horse.list.menu.header.show-name")).complete();
        this.m_142416_((GuiEventListener)showNameLabel);
        ECField genderLabel = ECField.Builder.start(270, y, headerWidth).withValue(I18n.getLabel("horse.list.menu.header.gender")).complete();
        this.m_142416_((GuiEventListener)genderLabel);
        ECField ageLabel = ECField.Builder.start(320, y, headerWidth).withValue(I18n.getLabel("horse.list.menu.header.age")).complete();
        this.m_142416_((GuiEventListener)ageLabel);
    }

    private void initRows() {
        int x = 10;
        int y = 43;
        for (HorseListItem item : ((HorseListPage)this.page).getItems()) {
            HorseListItemWidget row = new HorseListItemWidget(x, y, this.f_96543_ - 20, item);
            y += row.m_93694_() + 2;
            this.m_142416_((GuiEventListener)row);
        }
    }

    private void initSortOrderButton() {
        ECButton.Builder sortOrderButton = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20);
        if (((HorseListPage)this.page).getSortOrder() == HorseListSortOrder.NATURAL) {
            sortOrderButton = sortOrderButton.withLabel(I18n.getLabel("horse.list.menu.sort.by-age.button.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseListRefreshPacket(((HorseListPage)this.page).getPageNumber(), HorseListSortOrder.AGE, ((HorseListPage)this.page).getSortDirection(), (String)((HorseListPage)this.page).getFilterObject())));
        } else if (((HorseListPage)this.page).getSortOrder() == HorseListSortOrder.AGE) {
            sortOrderButton = sortOrderButton.withLabel(I18n.getLabel("horse.list.menu.sort.naturally.button.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseListRefreshPacket(((HorseListPage)this.page).getPageNumber(), HorseListSortOrder.NATURAL, ((HorseListPage)this.page).getSortDirection(), (String)((HorseListPage)this.page).getFilterObject())));
        }
        this.m_142416_((GuiEventListener)sortOrderButton.complete());
    }

    private void initSortDirectionButton() {
        ECButton.Builder sortDirectionButton = ECButton.Builder.start(this.f_96543_ - 140, this.f_96544_ - 25, 100, 20);
        if (((HorseListPage)this.page).getSortDirection() == SortDirection.ASCENDING) {
            sortDirectionButton = sortDirectionButton.withLabel(I18n.getLabel("horse.list.menu.order.descending.button.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseListRefreshPacket(((HorseListPage)this.page).getPageNumber(), (HorseListSortOrder)((Object)((Object)((HorseListPage)this.page).getSortOrder())), SortDirection.DESCENDING, (String)((HorseListPage)this.page).getFilterObject())));
        } else if (((HorseListPage)this.page).getSortDirection() == SortDirection.DESCENDING) {
            sortDirectionButton = sortDirectionButton.withLabel(I18n.getLabel("horse.list.menu.order.ascending.button.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseListRefreshPacket(((HorseListPage)this.page).getPageNumber(), (HorseListSortOrder)((Object)((Object)((HorseListPage)this.page).getSortOrder())), SortDirection.ASCENDING, (String)((HorseListPage)this.page).getFilterObject())));
        }
        this.m_142416_((GuiEventListener)sortDirectionButton.complete());
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

