/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.marking;

import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.horse.marking.HorseMarkingSelectListWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseMarkingSelectScreen
extends Screen {
    private final List<HorseCoatMarking> available;
    private final List<HorseCoatMarking> selected;
    private final Consumer<List<HorseCoatMarking>> onClick;
    private HorseMarkingSelectListWidget selectListWidget;

    public static void showScreen(List<HorseCoatMarking> available, List<HorseCoatMarking> selected, Consumer<List<HorseCoatMarking>> onClick) {
        HorseMarkingSelectScreen screen = new HorseMarkingSelectScreen(available, selected, onClick);
        ScreenStack.getInstance().push(screen);
    }

    protected HorseMarkingSelectScreen(List<HorseCoatMarking> available, List<HorseCoatMarking> selected, Consumer<List<HorseCoatMarking>> onClick) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.marking-select.menu.title")));
        this.available = available;
        this.selected = selected;
        this.onClick = onClick;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.selectListWidget = new HorseMarkingSelectListWidget(10, 35, this.f_96543_ - 100, this.f_96544_ - 55, this.available, this.selected);
        ECButton confirmButton = ECButton.Builder.start(this.f_96543_ - 10, this.f_96544_ - 30, 80, 20).withLabel(I18n.getLabel("horse.marking-select.menu.button.confirm.label")).withOnClick(this::onClick).rightAligned().complete();
        this.m_142416_((GuiEventListener)confirmButton);
    }

    private void onClick() {
        if (this.hasMoreThanOneFromTheSameGroup()) {
            return;
        }
        this.m_7379_();
        this.onClick.accept(this.selectListWidget.getSelectedMarkings());
    }

    private boolean hasMoreThanOneFromTheSameGroup() {
        LinkedHashSet<HorseCoatMarking.MarkingGroup> selectedGroups = new LinkedHashSet<HorseCoatMarking.MarkingGroup>();
        for (HorseCoatMarking selectedMarking : this.selectListWidget.getSelectedMarkings()) {
            if (selectedGroups.contains((Object)selectedMarking.getGroup())) {
                return true;
            }
            selectedGroups.add(selectedMarking.getGroup());
        }
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseMarkingSelectScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.selectListWidget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double partialTick) {
        return this.selectListWidget.m_6050_(mouseX, mouseY, partialTick) || super.m_6050_(mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTick) {
        return this.selectListWidget.m_6375_(mouseX, mouseY, partialTick) || super.m_6375_(mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        ScreenStack.getInstance().back();
    }
}

