/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.marking;

import com.equestricraft.common.Argb;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class HorseMarkingSelectWidget
extends ECWidget {
    private final HorseCoatMarking marking;
    private final ECField nameLabel;
    private final ECMultiLineField descriptionLabel;
    private boolean selected = false;

    protected HorseMarkingSelectWidget(int x, int y, int width, int height, HorseCoatMarking marking, boolean defaultSelected) {
        super(x, y, width, height);
        this.marking = marking;
        this.selected = defaultSelected;
        this.nameLabel = ECField.Builder.start(this.dx(width / 2), this.dy(0), width).withValue(I18n.getLabel(marking.getNameLabel())).withValueColor(this.selected ? Argb.ARGB_GREEN : Argb.ARGB_WHITE).centerAligned().complete();
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel(marking.getDescriptionLabel())).withColor(this.selected ? Argb.ARGB_GREEN : Argb.ARGB_WHITE).withPosition(this.dx(width / 2), this.dy(this.nameLabel.m_93694_())).withWidth(width).centerAlign().complete();
        this.setHeight(this.nameLabel.m_93694_() + this.descriptionLabel.getHeight());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public HorseCoatMarking getMarking() {
        return this.marking;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Argb color = this.selected ? Argb.ARGB_GREEN : Argb.ARGB_WHITE;
        this.nameLabel.f_93621_ = this.dy(0);
        this.nameLabel.setValueColor(color);
        this.nameLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionLabel.color(color).position(this.dx(this.f_93618_ / 2), this.dy(this.nameLabel.m_93694_())).render(poseStack);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.selected = !this.selected;
        return true;
    }
}

