/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.medicine;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class HorseMedicineWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField amountField;
    private final ECField boosterField;
    private final ECField overdoseField;
    private final int descriptionYLevel;
    private final ECMultiLineField descriptionLabel;

    protected HorseMedicineWidget(int x, int y, int width, HorseMedicineInformation medicine) {
        super(x, y, width, 0);
        int yLevel = 5;
        this.nameField = ECField.Builder.start(this.dx(5), this.dy(yLevel), width - 5).withValue(medicine.medicineName()).complete();
        String amountLabel = medicine.amount() + medicine.unitName();
        int sizeWidth = GuiUtil.getStandardTextWidth(amountLabel);
        this.amountField = ECField.Builder.start(this.dx(width - sizeWidth - 5), this.dy(yLevel), sizeWidth).withValue(amountLabel).complete();
        yLevel += 15;
        if (medicine.boosterNeeded()) {
            this.boosterField = ECField.Builder.start(this.dx(5), this.dy(yLevel), width - sizeWidth - 10).withValue(I18n.getLabel("horse-medicine.menu.booster-needed.label")).withValueColor(Argb.ARGB_GREEN).complete();
            yLevel += 15;
        } else {
            this.boosterField = null;
        }
        if (medicine.dailyOverdose() || medicine.maximumOverdose()) {
            this.overdoseField = ECField.Builder.start(this.dx(5), this.dy(yLevel), width - 5).withValue(I18n.getLabel("horse-medicine.menu.overdosed.label")).withValueColor(Argb.ARGB_RED).complete();
            yLevel += 15;
        } else {
            this.overdoseField = null;
        }
        this.descriptionYLevel = yLevel;
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(medicine.medicineDescription()).withWidth(width - 10).complete();
        this.setHeight(yLevel += this.descriptionLabel.getHeight());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(150, 200, 200, 200));
        } else {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(150, 150, 150, 150));
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.amountField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.boosterField != null) {
            this.boosterField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.overdoseField != null) {
            this.overdoseField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.descriptionLabel.position(this.dx(5), this.dy(this.descriptionYLevel)).render(poseStack);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }
}

