/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.progression;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.horse.progression.HorseProgressionMilestoneInfo;
import com.mojang.blaze3d.vertex.PoseStack;

public class HorseProgressionMilestoneWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField groupField;
    private final ECField unlockedField;
    private final ECProgressBar progressBar;

    protected HorseProgressionMilestoneWidget(int x, int y, int width, int horseXp, HorseProgressionMilestoneInfo horseProgressionMilestoneInfo) {
        super(x, y, width, 0);
        this.groupField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(horseProgressionMilestoneInfo.group()).withValueColor(horseProgressionMilestoneInfo.unlocked() ? Argb.ARGB_GREEN : Argb.ARGB_MC_GRAY).complete();
        this.nameField = ECField.Builder.start(this.dx(90), this.dy(0), width).withValue(horseProgressionMilestoneInfo.name()).withValueColor(horseProgressionMilestoneInfo.unlocked() ? Argb.ARGB_GREEN : Argb.ARGB_MC_GRAY).complete();
        if (horseProgressionMilestoneInfo.unlocked()) {
            this.unlockedField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(I18n.getLabel("horse.progression.menu.item.field.unlocked.label")).withValueColor(Argb.ARGB_GREEN).rightAligned().complete();
            this.progressBar = null;
        } else {
            this.unlockedField = null;
            this.progressBar = ECProgressBar.Builder.start(this.dx(width), this.dy(0), 100).withValue((int)((double)horseXp / (double)horseProgressionMilestoneInfo.xpRequired() * 100.0)).withFilledColor(Argb.ARGB_MC_AQUA).rightAligned().complete();
        }
        this.setHeight(GuiUtil.getSpacedLineHeight());
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.groupField.f_93621_ = this.dy(0);
        this.groupField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.unlockedField != null) {
            this.unlockedField.f_93621_ = this.dy(0);
            this.unlockedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.progressBar != null) {
            this.progressBar.f_93621_ = this.dy(0);
            this.progressBar.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

