/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.sale;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.sale.log.HorseSaleInfo;
import com.equestricraft.core.horse.sale.log.HorseSalePage;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.horse.sale.HorseSaleHistoryWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseSaleHistoryOpenPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseSaleHistoryMenu
extends PageScreen<HorseSalePage, HorseSaleInfo, Object, Object> {
    private final HorseSimple horse;

    public static void showMenu(HorseSimple horse, HorseSalePage page) {
        HorseSaleHistoryMenu screen = new HorseSaleHistoryMenu(horse, page);
        ScreenStack.getInstance().push(screen);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private HorseSaleHistoryMenu(HorseSimple horse, HorseSalePage page) {
        super(I18n.getLabel("horse.sale-history.menu.title", horse.name()), page);
        this.horse = horse;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        int x = 10;
        int y = 35;
        this.initHeader(x, y);
        this.initRows(x, y += GuiUtil.getSpacedLineHeight());
    }

    private void initHeader(int x, int y) {
        ECField timeHeader = ECField.Builder.start(x, y, this.f_96543_).withLabel(I18n.getLabel("horse.sale-history.menu.header.time.label")).complete();
        ECField playerHeader = ECField.Builder.start(x + 120, y, this.f_96543_).withLabel(I18n.getLabel("horse.sale-history.menu.header.player.label")).complete();
        ECField valueHeader = ECField.Builder.start(x + 250, y, this.f_96543_).withLabel(I18n.getLabel("horse.sale-history.menu.header.value.label")).complete();
        this.m_142416_((GuiEventListener)timeHeader);
        this.m_142416_((GuiEventListener)playerHeader);
        this.m_142416_((GuiEventListener)valueHeader);
    }

    private void initRows(int x, int y) {
        for (HorseSaleInfo item : ((HorseSalePage)this.page).getItems()) {
            HorseSaleHistoryWidget widget = new HorseSaleHistoryWidget(x, y, this.f_96543_ - 20, item);
            y += widget.m_93694_();
            this.m_142416_((GuiEventListener)widget);
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundHorseSaleHistoryOpenPacket packet = new ServerBoundHorseSaleHistoryOpenPacket(this.horse.id(), newPageNumber, ((HorseSalePage)this.page).getSortDirection());
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseSaleHistoryMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

