/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.tack;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.horse.tack.HorseTackTypeInfo;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseRemoveTackPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseFittedTackDetailScreen
extends Screen {
    private final int horseId;
    private final HorseTackTypeInfo tackInfo;
    private ECMultiLineField descriptionField = null;

    public static void showScreen(int horseId, HorseTackTypeInfo tackInfo) {
        HorseFittedTackDetailScreen screen = new HorseFittedTackDetailScreen(horseId, tackInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private HorseFittedTackDetailScreen(int horseId, HorseTackTypeInfo tackInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(tackInfo.tack().label()));
        this.horseId = horseId;
        this.tackInfo = tackInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField conditionField = ECField.Builder.start(10, 35, this.f_96543_ - 20).withLabel(I18n.getLabel("horse.tack-detail-screen.condition")).withValue(this.tackInfo.condition() + "%").complete();
        this.m_169394_((Widget)conditionField);
        ECField typeField = ECField.Builder.start(this.f_96543_ - 10, 10, this.f_96543_ - 20).withValue(this.tackInfo.type().name()).rightAligned().complete();
        this.m_142416_((GuiEventListener)typeField);
        this.descriptionField = ECMultiLineField.Builder.start().withPosition(10, 50).withWidth(this.f_96543_ - 20).withLabel(this.tackInfo.tack().description()).complete();
        ECButton removeButton = ECButton.Builder.start(10, 70, 120, 20).withLabel(I18n.getLabel("horse.tack-detail-screen.button.remove.label")).withOnClick(this::onRemoveClick).complete();
        this.m_142416_((GuiEventListener)removeButton);
    }

    private void onRemoveClick() {
        ServerBoundHorseRemoveTackPacket packet = new ServerBoundHorseRemoveTackPacket(this.horseId, this.tackInfo.type().type());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseFittedTackDetailScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionField.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

