/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.tack;

import com.equestricraft.common.Argb;
import com.equestricraft.common.NumberFormatter;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.client.gui.horse.tack.HorseFittedTackDetailScreen;
import com.equestricraft.mod.horse.tack.HorseTackTypeInfo;
import com.mojang.blaze3d.vertex.PoseStack;

public class HorseTackTypeWidget
extends ECWidget {
    private final int horseId;
    private final HorseTackTypeInfo info;
    private final ECField nameField;
    private final ECField currentItemField;
    private final ECField conditionField;

    protected HorseTackTypeWidget(int x, int y, int width, int horseId, HorseTackTypeInfo info2) {
        super(x, y, width, GuiUtil.getSpacedLineHeight());
        this.horseId = horseId;
        this.info = info2;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(info2.type().label()).withValueColor(Argb.ARGB_WHITE).complete();
        if (info2.tack() != null) {
            this.currentItemField = ECField.Builder.start(this.dx(110), this.dy(0), width).withValue(info2.tack().label()).withValueColor(Argb.ARGB_WHITE).complete();
            this.conditionField = ECField.Builder.start(this.dx(width - 80), this.dy(0), width).withValue(NumberFormatter.format2DP(info2.condition()) + "%").withValueColor(Argb.ARGB_WHITE).complete();
        } else {
            this.currentItemField = null;
            this.conditionField = null;
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.info.tack() != null) {
            HorseFittedTackDetailScreen.showScreen(this.horseId, this.info);
        }
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(-2), this.dy(-2), this.f_93618_ + 2, this.f_93619_ + 2, Argb.ARGB_WHITE.withTransparency(50));
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.currentItemField != null) {
            this.currentItemField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.conditionField != null) {
            this.conditionField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

