/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.vitamin;

import com.equestricraft.common.Argb;
import com.equestricraft.core.horse.information.HorseVitaminInformation;
import com.equestricraft.core.horse.nutrient.HorseNutrientStatus;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class HorseVitaminWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField valueField;
    private final ECField statusField;

    protected HorseVitaminWidget(int x, int y, int width, HorseVitaminInformation vitamin) {
        super(x, y, width, GuiUtil.getStandardLineHeight());
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(vitamin.name()).complete();
        this.valueField = ECField.Builder.start(this.dx(width / 2), this.dy(0), width).withValue(vitamin.displayValue()).withValueColor(Argb.ARGB_WHITE).centerAligned().complete();
        this.statusField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(vitamin.status().getTranslatedName()).withValueColor(this.colorForStatus(vitamin.status())).rightAligned().complete();
    }

    private Argb colorForStatus(HorseNutrientStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case HorseNutrientStatus.GOOD -> Argb.ARGB_GREEN;
            case HorseNutrientStatus.NOT_ENOUGH, HorseNutrientStatus.TOO_MUCH -> Argb.ARGB_RED;
        };
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.valueField.f_93621_ = this.dy(0);
        this.valueField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.statusField.f_93621_ = this.dy(0);
        this.statusField.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

