/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.weight;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.weight.HorseWeightLogEntry;
import com.equestricraft.core.horse.weight.HorseWeightPage;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.horse.weight.HorseWeightLogWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseWeightLogOpenPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class HorseWeightLogScreen
extends PageScreen<HorseWeightPage, HorseWeightLogEntry, Object, Object> {
    private final HorseSimple horse;

    public static void showScreen(HorseSimple horse, HorseWeightPage page) {
        HorseWeightLogScreen screen = new HorseWeightLogScreen(horse, page);
        ScreenStack.getInstance().push(screen);
    }

    private HorseWeightLogScreen(HorseSimple horse, HorseWeightPage page) {
        super(I18n.getLabel("horse.weight-log.menu.title", horse.name()), page);
        this.horse = horse;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        int x = 10;
        int y = 35;
        this.initHeader(x, y);
        this.initRows(x, y += GuiUtil.getSpacedLineHeight());
    }

    private void initHeader(int x, int y) {
        ECField dateHeader = ECField.Builder.start(x, y, this.f_96543_).withLabel(I18n.getLabel("horse.weight-log.menu.header.date.label")).complete();
        ECField weightHeader = ECField.Builder.start(x + 250, y, this.f_96543_).withLabel(I18n.getLabel("horse.weight-log.menu.header.weight.label")).complete();
        this.m_142416_((GuiEventListener)dateHeader);
        this.m_142416_((GuiEventListener)weightHeader);
    }

    private void initRows(int x, int y) {
        for (HorseWeightLogEntry item : ((HorseWeightPage)this.page).getItems()) {
            HorseWeightLogWidget widget = new HorseWeightLogWidget(x, y, this.f_96543_ - 20, item);
            y += widget.m_93694_();
            this.m_142416_((GuiEventListener)widget);
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundHorseWeightLogOpenPacket packet = new ServerBoundHorseWeightLogOpenPacket(this.horse.id(), newPageNumber, SortDirection.ASCENDING);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseWeightLogScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

