/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horseregistration;

import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundRegisterHorseWithOrganizationPacket;
import com.equestricraft.mod.registration.HorseRegistrationOrganizationInfo;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseRegistrationOrganizationMenu
extends Screen {
    private final HorseRegistrationOrganizationInfo info;
    private ECMultiLineField descriptionLabel = null;

    public static void showMenu(HorseRegistrationOrganizationInfo info2) {
        HorseRegistrationOrganizationMenu screen = new HorseRegistrationOrganizationMenu(info2);
        ScreenStack.getInstance().push(screen);
    }

    private HorseRegistrationOrganizationMenu(HorseRegistrationOrganizationInfo info2) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.registration-office.menu.title", info2.organization().name())));
        this.info = info2;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 30;
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(this.info.organization().description()).withWidth(this.f_96543_ - 20).withPosition(this.f_96543_ / 2, y).centerAlign().complete();
        y += this.descriptionLabel.getHeight() + GuiUtil.getStandardLineHeight();
        if (this.info.hasRegistration()) {
            ECField registrationNumberLabel = ECField.Builder.start(10, y, this.f_96543_ - 20).withLabel(I18n.getLabel("horse.registration-office.menu.field.registration-number.label")).withValue(this.info.registrationNumber()).complete();
            this.m_142416_((GuiEventListener)registrationNumberLabel);
            ECField showNameLabel = ECField.Builder.start(10, y += GuiUtil.getSpacedLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse.registration-office.menu.field.show-name.label")).withValue(this.info.showName()).complete();
            this.m_142416_((GuiEventListener)showNameLabel);
            ECField dateLabel = ECField.Builder.start(10, y += GuiUtil.getSpacedLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse.registration-office.menu.field.registered-date.label")).withValue(DateFormatter.formatDateFull(this.info.registrationDate())).complete();
            this.m_142416_((GuiEventListener)dateLabel);
            ECField registeredByPlayerLabel = ECField.Builder.start(10, y += GuiUtil.getSpacedLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse.registration-office.menu.field.registered-by-player.label")).withValue(this.info.registeredByPlayer().ign()).complete();
            this.m_142416_((GuiEventListener)registeredByPlayerLabel);
        } else {
            ECButton registerButton = ECButton.Builder.start(this.f_96543_ / 2, y, 100, 20).withLabel(I18n.getLabel("horse.registration-office.menu.button.register.label")).withOnClick(() -> Network.sendToServer(new ServerBoundRegisterHorseWithOrganizationPacket(this.info.horseId(), this.info.organization().id()))).centerAligned().complete();
            this.m_142416_((GuiEventListener)registerButton);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseRegistrationOrganizationMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionLabel.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

