/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horseregistration;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationSimple;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundConfirmHorseRegistrationPacket;
import com.equestricraft.mod.packet.ServerBoundRequestRandomShowNameForRegistrationPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseRegistrationPrompt
extends Screen {
    private static HorseRegistrationPrompt screen = null;
    private final int horseId;
    private final HorseRegistrationOrganizationSimple organization;
    private ECMultiLineField descriptionField = null;
    private ECTextField showNameField = null;

    public static void showScreen(int horseId, HorseRegistrationOrganizationSimple organization) {
        screen = new HorseRegistrationPrompt(horseId, organization);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public static void setShowName(String showName) {
        HorseRegistrationPrompt.screen.showNameField.setValue(showName);
    }

    private HorseRegistrationPrompt(int horseId, HorseRegistrationOrganizationSimple organization) {
        super((Component)ComponentUtil.buildColoredTextComponent(organization.name()));
        this.horseId = horseId;
        this.organization = organization;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField priceField = ECField.Builder.start(this.f_96543_ / 2, 25, this.f_96543_).withLabel(I18n.getLabel("horse.registration.prompt.price")).withValue(this.organization.priceFormatted()).centerAligned().complete();
        this.descriptionField = ECMultiLineField.Builder.start().withLabel(this.organization.description()).withWidth(this.f_96543_ - 20).withPosition(this.f_96543_ / 2, 40).centerAlign().complete();
        int y = 40 + this.descriptionField.getHeight() + 10;
        this.showNameField = ECTextField.Builder.start(10, y, 210).withLabel(I18n.getLabel("horse.registration.prompt.field.show-name.label")).complete();
        ECButton randomButton = ECButton.Builder.start(230, y, 70, 15).withLabel(I18n.getLabel("horse.registration.prompt.button.random.label")).withOnClick(() -> Network.sendToServer(new ServerBoundRequestRandomShowNameForRegistrationPacket())).complete();
        ECButton registerButton = ECButton.Builder.start(this.f_96543_ / 2, this.f_96544_ - 70, 150, 20).withLabel(I18n.getLabel("horse.registration.prompt.button.register.label")).withOnClick(() -> {
            String showName = this.showNameField.getValue();
            ServerBoundConfirmHorseRegistrationPacket packet = new ServerBoundConfirmHorseRegistrationPacket(this.horseId, this.organization.id(), showName);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)priceField);
        this.m_142416_((GuiEventListener)this.showNameField);
        this.m_142416_((GuiEventListener)randomButton);
        this.m_142416_((GuiEventListener)registerButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseRegistrationPrompt.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionField.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

