/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.inventory;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.inventory.PlayerInventoryItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlayerInventoryScreenRefreshPacket;
import com.equestricraft.mod.player.inventory.PlayerInventoryListItem;
import com.equestricraft.mod.player.inventory.PlayerInventoryPage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerInventoryScreen
extends PageScreen<PlayerInventoryPage, PlayerInventoryListItem, Object, Object> {
    public static void showScreen(PlayerInventoryPage page) {
        PlayerInventoryScreen screen = new PlayerInventoryScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected PlayerInventoryScreen(PlayerInventoryPage page) {
        super(I18n.getLabel("player-inventory.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initHeader();
        this.initItems();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlayerInventoryScreenRefreshPacket packet = new ServerBoundPlayerInventoryScreenRefreshPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    private void initHeader() {
        int y = 20;
        ECField nameLabel = ECField.Builder.start(10, y, this.f_96543_).withValue(I18n.getLabel("player-inventory.menu.header.name.label")).complete();
        this.m_142416_((GuiEventListener)nameLabel);
        ECField quantityLabel = ECField.Builder.start(this.f_96543_ - 60, y, this.f_96543_).withValue(I18n.getLabel("player-inventory.menu.header.quantity.label")).complete();
        this.m_142416_((GuiEventListener)quantityLabel);
    }

    private void initItems() {
        int x = 10;
        int y = 20 + GuiUtil.getSpacedLineHeight();
        for (PlayerInventoryListItem item : ((PlayerInventoryPage)this.page).getItems()) {
            PlayerInventoryItemWidget card = new PlayerInventoryItemWidget(x, y, this.f_96543_ - 20, item);
            y += card.m_93694_();
            this.m_142416_((GuiEventListener)card);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerInventoryScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

