/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.job.request.JobRequestInfo;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundJobRequestCompletePacket;
import com.mojang.blaze3d.vertex.PoseStack;

public class JobAssignedRequestWidget
extends ECWidget {
    private final ECField requesterField;
    private final ECField timeField;
    private final ECField descriptionField;
    private final ECButton assignButton;

    protected JobAssignedRequestWidget(int x, int y, int width, JobRequestInfo request) {
        super(x, y, width, GuiUtil.getSpacedLineHeight());
        this.requesterField = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(request.requester().ign()).complete();
        this.timeField = ECField.Builder.start(this.dx(100), this.dy(0), width).withLabel(I18n.getLabel("job.requests.menu.item.days.label", DateUtils.daysSince(request.createdTime()))).complete();
        this.descriptionField = ECField.Builder.start(this.dx(170), this.dy(0), width).withLabel(request.description()).complete();
        this.assignButton = ECButton.Builder.start(this.dx(width - 80), this.dy(0), 80, GuiUtil.getSpacedLineHeight()).withLabel(I18n.getLabel("job.requests.menu.item.button.complete.label")).withOnClick(() -> {
            ServerBoundJobRequestCompletePacket packet = new ServerBoundJobRequestCompletePacket(request.id());
            Network.sendToServer(packet);
        }).complete();
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.assignButton.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.requesterField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.timeField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.assignButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

