/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.invoice.JobInvoiceInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPayInvoicePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobInvoiceDetailsScreen
extends Screen {
    private final JobInvoiceInfo invoice;
    private ECMultiLineField descriptionField = null;

    public static void showScreen(JobInvoiceInfo invoice) {
        JobInvoiceDetailsScreen screen = new JobInvoiceDetailsScreen(invoice);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private JobInvoiceDetailsScreen(JobInvoiceInfo invoice) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("job.invoice.details-menu.title", invoice.invoiceId())));
        this.invoice = invoice;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 35;
        if (this.invoice.overdue()) {
            ECField overdueField = ECField.Builder.start(this.f_96543_ - 10, 10, this.f_96543_).withValue(I18n.getLabel("job.invoice.details-menu.overdue.label")).withValueColor(Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)overdueField);
        }
        ECField titleField = ECField.Builder.start(10, y, this.f_96543_ - 20).withValue(this.invoice.title()).complete();
        this.m_142416_((GuiEventListener)titleField);
        ECField playerField = ECField.Builder.start(10, y += GuiUtil.getStandardLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("job.invoice.details-menu.field.player.label")).withValue(this.invoice.fromPlayer().ign()).complete();
        this.m_142416_((GuiEventListener)playerField);
        ECField payment = ECField.Builder.start(10, y += GuiUtil.getStandardLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("job.invoice.details-menu.field.value.label")).withValue(this.invoice.paymentValueFormatted()).complete();
        this.m_142416_((GuiEventListener)payment);
        this.descriptionField = ECMultiLineField.Builder.start().withPosition(10, y += GuiUtil.getStandardLineHeight()).withWidth(this.f_96543_ - 20).withLabel(this.invoice.description()).complete();
        ECButton payButton = ECButton.Builder.start(this.f_96543_ / 2, (y += this.descriptionField.getHeight()) + 10, 100, 20).withLabel(I18n.getLabel("job.invoice.details-menu.button.pay.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPayInvoicePacket(this.invoice.invoiceId()))).centerAligned().complete();
        this.m_142416_((GuiEventListener)payButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobInvoiceDetailsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionField.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

