/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.invoice.JobInvoiceInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.job.JobInvoiceWidget;
import com.equestricraft.mod.job.activework.JobInvoicePage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlayerInvoiceListOpenPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobInvoiceListScreen
extends PageScreen<JobInvoicePage, JobInvoiceInfo, Object, Object> {
    public static void showScreen(JobInvoicePage page) {
        JobInvoiceListScreen screen = new JobInvoiceListScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private JobInvoiceListScreen(JobInvoicePage page) {
        super(I18n.getLabel("job.invoice.list.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initHeader();
        this.initRows();
    }

    private void initHeader() {
        int y = 30;
        int headerWidth = this.f_96543_ - 20;
        ECField invoiceNumberLabel = ECField.Builder.start(5, y, headerWidth).withValue(I18n.getLabel("job.invoice.list.header.number.label")).complete();
        this.m_142416_((GuiEventListener)invoiceNumberLabel);
        ECField titleLabel = ECField.Builder.start(40, y, headerWidth).withLabel(I18n.getLabel("job.invoice.list.header.title.label")).complete();
        this.m_142416_((GuiEventListener)titleLabel);
        ECField playerLabel = ECField.Builder.start(this.f_96543_ - 255, y, headerWidth).withLabel(I18n.getLabel("job.invoice.list.header.player.label")).complete();
        this.m_142416_((GuiEventListener)playerLabel);
        ECField valueLabel = ECField.Builder.start(this.f_96543_ - 155, y, headerWidth).withLabel(I18n.getLabel("job.invoice.list.header.value.label")).complete();
        this.m_142416_((GuiEventListener)valueLabel);
        ECField timeLabel = ECField.Builder.start(this.f_96543_ - 85, y, headerWidth).withLabel(I18n.getLabel("job.invoice.list.header.time.label")).complete();
        this.m_142416_((GuiEventListener)timeLabel);
    }

    private void initRows() {
        int x = 5;
        int y = 43;
        for (JobInvoiceInfo item : ((JobInvoicePage)this.page).getItems()) {
            JobInvoiceWidget row = new JobInvoiceWidget(x, y, this.f_96543_ - 10, item);
            y += row.m_93694_() + 2;
            this.m_142416_((GuiEventListener)row);
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlayerInvoiceListOpenPacket packet = new ServerBoundPlayerInvoiceListOpenPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobInvoiceListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

