/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.Argb;
import com.equestricraft.common.DurationFormatter;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.job.invoice.JobInvoiceInfo;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.client.gui.job.JobInvoiceDetailsScreen;
import com.mojang.blaze3d.vertex.PoseStack;

public class JobInvoiceWidget
extends ECWidget {
    private final JobInvoiceInfo invoice;
    private final ECField invoiceNumberField;
    private final ECField titleField;
    private final ECField fromPlayerField;
    private final ECField valueField;
    private final ECField timeStampField;

    protected JobInvoiceWidget(int x, int y, int width, JobInvoiceInfo invoice) {
        super(x, y, width, 0);
        this.invoice = invoice;
        this.invoiceNumberField = ECField.Builder.start(this.dx(0), this.dy(0), 30).withValue(invoice.invoiceId()).withValueColor(Argb.ARGB_WHITE).complete();
        this.titleField = ECField.Builder.start(this.dx(35), this.dy(0), 80).withValue(invoice.title()).withValueColor(Argb.ARGB_WHITE).complete();
        this.fromPlayerField = ECField.Builder.start(this.dx(width - 250), this.dy(0), 100).withValue(invoice.fromPlayer().ign()).withValueColor(Argb.ARGB_WHITE).complete();
        this.valueField = ECField.Builder.start(this.dx(width - 150), this.dy(0), 70).withValue(invoice.paymentValueFormatted()).withValueColor(Argb.ARGB_WHITE).complete();
        this.timeStampField = ECField.Builder.start(this.dx(width - 80), this.dy(0), 80).withValue(DurationFormatter.formatDuration(DateUtils.durationSince(invoice.time()))).withValueColor(Argb.ARGB_WHITE).complete();
        this.setHeight(GuiUtil.getSpacedLineHeight());
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        JobInvoiceDetailsScreen.showScreen(this.invoice);
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.invoiceNumberField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.titleField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.fromPlayerField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.valueField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.timeStampField.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

