/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.job.JobMemberCard;
import com.equestricraft.mod.job.JobMemberInfo;
import com.equestricraft.mod.job.JobScreenPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundJobMemberMenuRefreshPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JobMembersScreen
extends PageScreen<JobScreenPage, JobMemberInfo, Object, Object> {
    private final int jobId;

    public static void showJobMembersScreen(int jobId, String jobName, JobScreenPage jobScreenPage) {
        JobMembersScreen prompt = new JobMembersScreen(jobId, jobName, jobScreenPage);
        Minecraft.m_91087_().m_91152_((Screen)prompt);
    }

    public JobMembersScreen(int jobId, String jobName, JobScreenPage jobScreenPage) {
        super(I18n.getLabel("job.member-menu.title", jobName), jobScreenPage);
        this.jobId = jobId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initMembers();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundJobMemberMenuRefreshPacket packet = new ServerBoundJobMemberMenuRefreshPacket(this.jobId, newPageNumber);
        Network.sendToServer(packet);
    }

    private void initMembers() {
        int x = 20;
        int y = 25;
        for (JobMemberInfo jobMember : ((JobScreenPage)this.page).getItems()) {
            JobMemberCard card = new JobMemberCard(x, y, 93, 80, jobMember);
            if ((x += 100) + 100 > this.f_96543_) {
                x = 15;
                y += 85;
            }
            this.m_142416_((GuiEventListener)card);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobMembersScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

