/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.JobInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.job.JobRequestWorkScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundJobMemberMenuRefreshPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobMenuScreen
extends Screen {
    private final JobInfo jobInfo;
    private ECMultiLineField descriptionLabel = null;

    public static void showScreen(JobInfo jobInfo) {
        JobMenuScreen screen = new JobMenuScreen(jobInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private JobMenuScreen(JobInfo jobInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("job.menu.title", jobInfo.name())));
        this.jobInfo = jobInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField headsField = ECField.Builder.start(20, 25, this.f_96543_ - 40).withLabel(I18n.getLabel("job.menu.field.job-heads.label")).withValue(String.join((CharSequence)", ", this.jobInfo.heads())).complete();
        this.m_142416_((GuiEventListener)headsField);
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(this.jobInfo.description()).withWidth(this.f_96543_ - 40).withPosition(20, 40).complete();
        ECButton viewMembersButton = ECButton.Builder.start(this.f_96543_ / 2, 150, 100, 20).withLabel(I18n.getLabel("job.menu.button.view-members.label")).withOnClick(() -> Network.sendToServer(new ServerBoundJobMemberMenuRefreshPacket(this.jobInfo.id(), 1))).centerAligned().complete();
        this.m_142416_((GuiEventListener)viewMembersButton);
        ECButton requestWorkButton = ECButton.Builder.start(this.f_96543_ / 2, 180, 100, 20).withLabel(I18n.getLabel("job.menu.button.request-work.label")).withOnClick(() -> JobRequestWorkScreen.showMenu(this.jobInfo)).centerAligned().complete();
        this.m_142416_((GuiEventListener)requestWorkButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.descriptionLabel.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

