/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.JobInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundCreateJobRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobRequestWorkScreen
extends Screen {
    private final JobInfo job;

    public static void showMenu(JobInfo job) {
        JobRequestWorkScreen screen = new JobRequestWorkScreen(job);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private JobRequestWorkScreen(JobInfo job) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("job.request-work.menu.title", job.name())));
        this.job = job;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField descriptionField = ECTextField.Builder.start(10, 35, this.f_96543_ - 20).withMaximumLength(255).withLabel(I18n.getLabel("job.request-work.menu.description.label")).complete();
        this.m_142416_((GuiEventListener)descriptionField);
        ECButton sendRequestButton = ECButton.Builder.start(10, 50, 80, 20).withLabel(I18n.getLabel("job.request-work.menu.button.send.label")).withOnClick(() -> {
            this.m_7379_();
            ServerBoundCreateJobRequestPacket packet = new ServerBoundCreateJobRequestPacket(this.job.id(), descriptionField.getValue());
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)sendRequestButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobRequestWorkScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

