/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.job;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundJobStartWorkPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class JobStartWorkMenu
extends Screen {
    private final int forPlayerId;

    public static void showScreen(int forPlayerId) {
        JobStartWorkMenu screen = new JobStartWorkMenu(forPlayerId);
        ScreenStack.getInstance().push(screen);
    }

    private JobStartWorkMenu(int forPlayerId) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("job.start-work.menu.title")));
        this.forPlayerId = forPlayerId;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField titleField = ECTextField.Builder.start(10, 35, this.f_96543_ - 20).withLabel(I18n.getLabel("job.start-work.menu.field.title.label")).withMaximumLength(60).complete();
        this.m_142416_((GuiEventListener)titleField);
        ECTextField descriptionField = ECTextField.Builder.start(10, 55, this.f_96543_ - 20).withLabel(I18n.getLabel("job.start-work.menu.field.description.label")).complete();
        this.m_142416_((GuiEventListener)descriptionField);
        ECTextField estimatedPriceField = ECTextField.Builder.start(10, 75, this.f_96543_ - 20).withLabel(I18n.getLabel("job.start-work.menu.field.estimated-price.label")).withFilter(NumberUtils::isNumeric).complete();
        this.m_142416_((GuiEventListener)estimatedPriceField);
        ECButton startButton = ECButton.Builder.start(this.f_96543_ / 2, 100, 100, 20).withLabel(I18n.getLabel("job.start-work.menu.button.start.label")).withOnClick(() -> {
            String title = titleField.getValue();
            String description = descriptionField.getValue();
            String priceString = estimatedPriceField.getValue();
            if (title.isEmpty() || description.isEmpty() || priceString.isEmpty()) {
                return;
            }
            double price = Double.parseDouble(priceString);
            super.m_7379_();
            ServerBoundJobStartWorkPacket packet = new ServerBoundJobStartWorkPacket(this.forPlayerId, title, description, price);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)startButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        JobStartWorkMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

