/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.leaderboard;

import com.equestricraft.common.Argb;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.leaderboard.LeaderboardEntryInfo;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Date;

public class LeaderboardEntryWidget
extends ECWidget {
    private final ECField positionLabel;
    private final ECField ignLabel;
    private final ECField scoreLabel;
    private final ECField timeLabel;
    private static final int POS_X = 0;
    private static final int POS_WIDTH = 25;
    private static final int IGN_X = 30;
    private static final int IGN_WIDTH = 150;
    private static final int SCORE_X = 185;
    private static final int SCORE_WIDTH = 80;
    private static final int TIME_X = 270;
    private static final int TIME_WIDTH = 80;

    protected LeaderboardEntryWidget(int x, int y, int width, int height, String scoreLabelText, LeaderboardEntryInfo entry) {
        super(x, y, width, height);
        this.positionLabel = ECField.Builder.start(this.dx(0), this.dy(0), 25).withValue(entry != null ? Integer.valueOf(entry.position()) : I18n.getLabel("leaderboard.menu.table.header.pos.label")).withValueColor(entry != null ? Argb.ARGB_WHITE : Argb.ARGB_AQUA).complete();
        this.ignLabel = ECField.Builder.start(this.dx(30), this.dy(0), 150).withValue(entry != null ? entry.player().ign() : I18n.getLabel("leaderboard.menu.table.header.ign.label")).withValueColor(entry != null ? Argb.ARGB_WHITE : Argb.ARGB_AQUA).complete();
        this.scoreLabel = ECField.Builder.start(this.dx(185), this.dy(0), 80).withValue(entry != null ? Double.valueOf(entry.score()) : scoreLabelText).withValueColor(entry != null ? Argb.ARGB_WHITE : Argb.ARGB_AQUA).complete();
        this.timeLabel = ECField.Builder.start(this.dx(270), this.dy(0), 80).withValue(entry != null ? DateFormatter.formatDateFull(new Date(entry.timeStamp())) : I18n.getLabel("leaderboard.menu.table.header.time.label")).withValueColor(entry != null ? Argb.ARGB_WHITE : Argb.ARGB_AQUA).complete();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.positionLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.ignLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.scoreLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.timeLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }
}

