/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.leaderboard;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.leaderboard.LeaderboardSimpleInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundLeaderboardOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class LeaderboardListScreen
extends Screen {
    private final List<LeaderboardSimpleInfo> leaderboards;

    public static void showScreen(List<LeaderboardSimpleInfo> leaderboards) {
        LeaderboardListScreen screen = new LeaderboardListScreen(leaderboards);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private LeaderboardListScreen(List<LeaderboardSimpleInfo> leaderboards) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("leaderboard-list.menu.title")));
        this.leaderboards = leaderboards;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 25;
        for (LeaderboardSimpleInfo leaderboard : this.leaderboards) {
            int buttonWidth = GuiUtil.getStandardTextWidth(leaderboard.leaderboardName()) + 15;
            ECButton button = ECButton.Builder.start(this.f_96543_ / 2, y, buttonWidth, 20).withLabel(leaderboard.leaderboardName()).withOnClick(() -> Network.sendToServer(new ServerBoundLeaderboardOpenPacket(leaderboard.leaderboardId()))).centerAligned().complete();
            this.m_142416_((GuiEventListener)button);
            y += 25;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        LeaderboardListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

