/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.medicine;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.medicine.MedicineInventoryItemInfo;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class MedicineInventoryItemWidget
extends ECWidget {
    private final MedicineInventoryItemInfo medicine;
    private final ECField nameField;
    private final ECField quantityField;
    private final ECMultiLineField descriptionField;
    private final Consumer<MedicineInventoryItemInfo> onClick;

    protected MedicineInventoryItemWidget(int x, int y, int width, MedicineInventoryItemInfo medicine, Consumer<MedicineInventoryItemInfo> onClick) {
        super(x, y, width, 0);
        this.medicine = medicine;
        this.onClick = onClick;
        int currentY = 0;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withValue(medicine.medicine().name()).complete();
        this.quantityField = ECField.Builder.start(this.dx(0), this.dy(currentY += this.nameField.m_93694_()), width).withLabel(I18n.getLabel("medicine.inventory.menu.field.quantity.label")).withValue(medicine.quantity()).complete();
        this.descriptionField = ECMultiLineField.Builder.start().withWidth(width).withLabel(medicine.medicine().description()).withPosition(this.dx(0), this.dy(currentY += this.quantityField.m_93694_())).complete();
        this.setHeight(currentY += this.descriptionField.getHeight());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.quantityField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionField.render(poseStack);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.medicine);
        return true;
    }
}

