/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.medicine;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.medicine.MedicineInventoryItemInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.medicine.MedicineInventoryItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundMedicineInventoryItemSelectPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerMedicineInventoryMenu
extends Screen {
    private final int horseId;
    private final List<MedicineInventoryItemInfo> medicines;
    private int scroll = 0;
    private int totalHeight;
    private final List<MedicineInventoryItemWidget> widgets = new ArrayList<MedicineInventoryItemWidget>(0);

    public static void showScreen(int horseId, List<MedicineInventoryItemInfo> medicines) {
        PlayerMedicineInventoryMenu screen = new PlayerMedicineInventoryMenu(horseId, medicines);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlayerMedicineInventoryMenu(int horseId, List<MedicineInventoryItemInfo> medicines) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("medicine.inventory.menu.title")));
        this.horseId = horseId;
        this.medicines = medicines;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerMedicineInventoryMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int y = 35;
        int widgetWidth = this.f_96543_ - 40;
        this.widgets.clear();
        for (MedicineInventoryItemInfo item : this.medicines) {
            MedicineInventoryItemWidget widget = new MedicineInventoryItemWidget(20, y + this.scroll, widgetWidth, item, this::onClick);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.widgets.add(widget);
            y += widget.m_93694_() + 10;
        }
        this.totalHeight = y;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onClick(MedicineInventoryItemInfo medicine) {
        this.m_7379_();
        ServerBoundMedicineInventoryItemSelectPacket packet = new ServerBoundMedicineInventoryItemSelectPacket(this.horseId, medicine.medicine().id());
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        for (MedicineInventoryItemWidget widget : this.widgets) {
            if (!widget.m_6375_(mouseX, mouseY, action)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, action);
    }
}

