/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.navigator;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.navigator.NavigatorItemInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundNavigatorTPPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class NavigatorMenuScreen
extends Screen {
    private final List<NavigatorItemInfo> items;

    public static void showScreen(List<NavigatorItemInfo> items) {
        NavigatorMenuScreen screen = new NavigatorMenuScreen(items);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected NavigatorMenuScreen(List<NavigatorItemInfo> items) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("navigator.menu.title")));
        this.items = items;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 30;
        for (NavigatorItemInfo item : this.items) {
            ECButton button = ECButton.Builder.start(this.f_96543_ / 2, y, 100, 20).withLabel(item.name()).withOnClick(() -> this.onClick(item)).centerAligned().complete();
            this.m_142416_((GuiEventListener)button);
            y += button.m_93694_() + 10;
        }
    }

    private void onClick(NavigatorItemInfo item) {
        this.m_7379_();
        ServerBoundNavigatorTPPacket packet = new ServerBoundNavigatorTPPacket(item.id());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        NavigatorMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

