/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.nickname;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.ColorPicker;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.nickname.AdvancedNicknameChangeRequest;
import com.equestricraft.mod.nickname.AdvancedNicknameLetter;
import com.equestricraft.mod.packet.ServerBoundChangePlayersNicknameAdvancedPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class NicknameAdvancedScreen
extends Screen {
    private final List<AdvancedNicknameLetter> letters;
    private final AtomicBoolean boldSelected;
    private final AtomicBoolean italicSelected;

    public static void showScreen(AdvancedNicknameChangeRequest request) {
        NicknameAdvancedScreen screen = new NicknameAdvancedScreen(request);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private NicknameAdvancedScreen(AdvancedNicknameChangeRequest request) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("nickname-advanced.menu.title")));
        this.letters = request.letters();
        this.boldSelected = new AtomicBoolean(request.bold());
        this.italicSelected = new AtomicBoolean(request.italic());
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField letterEntryField = ECTextField.Builder.start(this.f_96543_ / 2 - 50, 45, 100).withLabel(I18n.getLabel("nickname-advanced.menu.field.enter-character.label")).complete();
        this.m_142416_((GuiEventListener)letterEntryField);
        ECButton backspaceButton = ECButton.Builder.start(this.f_96543_ - 100, 45, 80, 20).withLabel(I18n.getLabel("nickname-advanced.menu.button.backspace.label")).withOnClick(() -> {
            if (!this.letters.isEmpty()) {
                this.letters.remove(this.letters.size() - 1);
            }
        }).complete();
        this.m_142416_((GuiEventListener)backspaceButton);
        ColorPicker colorPicker = new ColorPicker(10, 70, this.f_96543_ - 20);
        this.m_142416_((GuiEventListener)colorPicker);
        ECCheckbox boldCheckbox = ECCheckbox.Builder.start(140, 140).withText(I18n.getLabel("nickname-advanced.menu.checkbox.bold.label")).withDefaultSelected(this.boldSelected.get()).withOnClick(c -> this.boldSelected.set(c.isSelected())).complete();
        this.m_142416_((GuiEventListener)boldCheckbox);
        ECCheckbox italicCheckbox = ECCheckbox.Builder.start(220, 140).withText(I18n.getLabel("nickname-advanced.menu.checkbox.italic.label")).withDefaultSelected(this.italicSelected.get()).withOnClick(c -> this.italicSelected.set(c.isSelected())).complete();
        this.m_142416_((GuiEventListener)italicCheckbox);
        ECButton addLetterButton = ECButton.Builder.start(this.f_96543_ / 2, 170, 120, 20).withLabel(I18n.getLabel("nickname-builder.menu.button.add-letter.label")).withOnClick(() -> {
            String letter = letterEntryField.getValue();
            if (letter.isEmpty()) {
                return;
            }
            Argb color = colorPicker.getColor();
            AdvancedNicknameLetter letterEntry = new AdvancedNicknameLetter(Character.valueOf(letter.charAt(0)), color);
            this.letters.add(letterEntry);
            letterEntryField.setValue("");
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)addLetterButton);
        ECButton changeNicknameButton = ECButton.Builder.start(this.f_96543_ / 2, 200, 120, 20).withLabel(I18n.getLabel("nickname-advanced.menu.button.change-nickname.label")).withOnClick(() -> {
            if (this.letters.isEmpty()) {
                return;
            }
            AdvancedNicknameChangeRequest request = new AdvancedNicknameChangeRequest(this.letters, this.boldSelected.get(), this.italicSelected.get());
            this.m_7379_();
            ServerBoundChangePlayersNicknameAdvancedPacket packet = new ServerBoundChangePlayersNicknameAdvancedPacket(request);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)changeNicknameButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        NicknameAdvancedScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        TextComponent currentNickname = new TextComponent("");
        if (this.boldSelected.get()) {
            currentNickname.m_130940_(ChatFormatting.BOLD);
        }
        if (this.italicSelected.get()) {
            currentNickname.m_130940_(ChatFormatting.ITALIC);
        }
        for (AdvancedNicknameLetter letter : this.letters) {
            TextComponent letterComponent = new TextComponent(letter.letter().toString());
            Style style = letterComponent.m_7383_().m_178520_(letter.color().getIntValue());
            letterComponent.m_6270_(style);
            currentNickname.m_7220_((Component)letterComponent);
        }
        NicknameAdvancedScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)currentNickname, (int)(this.f_96543_ / 2), (int)25, (int)GuiConstants.COLOR_WHITE);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

