/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.nickname;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.components.ScrollableList;
import com.equestricraft.mod.client.gui.components.ScrollableListItem;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.nickname.NicknameChangeRequest;
import com.equestricraft.mod.nickname.NicknameLetter;
import com.equestricraft.mod.packet.ServerBoundNicknameChangePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class NicknameBuilderScreen
extends Screen {
    private final boolean canUseFormattingCodes;
    private final List<NicknameLetter> letters;
    private final AtomicBoolean boldSelected;
    private final AtomicBoolean italicSelected;

    public static void showScreen(boolean canUseFormattingCodes, NicknameChangeRequest request) {
        NicknameBuilderScreen screen = new NicknameBuilderScreen(canUseFormattingCodes, request);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private NicknameBuilderScreen(boolean canUseFormattingCodes, NicknameChangeRequest request) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("nickname-builder.menu.title")));
        this.canUseFormattingCodes = canUseFormattingCodes;
        this.letters = request.letters();
        this.boldSelected = new AtomicBoolean(request.bold());
        this.italicSelected = new AtomicBoolean(request.italic());
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField entryField = ECTextField.Builder.start(this.f_96543_ / 2 - 50, 70, 100).withLabel(I18n.getLabel("nickname-builder.menu.field.enter-character.label")).complete();
        this.m_142416_((GuiEventListener)entryField);
        ECButton backspaceButton = ECButton.Builder.start(this.f_96543_ - 100, 70, 80, 20).withLabel(I18n.getLabel("nickname-builder.menu.button.backspace.label")).withOnClick(() -> {
            if (!this.letters.isEmpty()) {
                this.letters.remove(this.letters.size() - 1);
            }
        }).complete();
        this.m_142416_((GuiEventListener)backspaceButton);
        ScrollableList colors = new ScrollableList(10, 100, this.f_96543_ - 20, 20, this.buildColorItems(), 1);
        this.m_142416_((GuiEventListener)colors);
        int y = 130;
        if (this.canUseFormattingCodes) {
            ECCheckbox boldCheckbox = ECCheckbox.Builder.start(80, y).withText(I18n.getLabel("nickname-builder.menu.checkbox.bold.label")).withDefaultSelected(this.boldSelected.get()).withOnClick(c -> this.boldSelected.set(c.isSelected())).complete();
            this.m_142416_((GuiEventListener)boldCheckbox);
            ECCheckbox italicCheckbox = ECCheckbox.Builder.start(140, y).withText(I18n.getLabel("nickname-builder.menu.checkbox.italic.label")).withDefaultSelected(this.italicSelected.get()).withOnClick(c -> this.italicSelected.set(c.isSelected())).complete();
            this.m_142416_((GuiEventListener)italicCheckbox);
            y += 30;
        }
        ECButton addLetterButton = ECButton.Builder.start(this.f_96543_ / 2, y, 120, 20).withLabel(I18n.getLabel("nickname-builder.menu.button.add-letter.label")).withOnClick(() -> {
            String letter = entryField.getValue();
            if (letter.isEmpty()) {
                return;
            }
            char character = letter.charAt(0);
            List<Integer> colorSelection = colors.getSelected();
            String color = colorSelection.isEmpty() ? "&f" : this.getColorFromSelection(colorSelection.get(0));
            NicknameLetter entry = new NicknameLetter(Character.valueOf(character), color);
            this.letters.add(entry);
            entryField.setValue("");
            colors.setSelected(Collections.emptyList());
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)addLetterButton);
        ECButton changeNicknameButton = ECButton.Builder.start(this.f_96543_ / 2, y += 30, 120, 20).withLabel(I18n.getLabel("nickname-builder.menu.button.change-nickname.label")).withOnClick(() -> {
            NicknameChangeRequest request = new NicknameChangeRequest(this.letters, this.boldSelected.get(), this.italicSelected.get());
            this.m_7379_();
            ServerBoundNicknameChangePacket packet = new ServerBoundNicknameChangePacket(request);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)changeNicknameButton);
    }

    private String getColorFromSelection(int selectionId) {
        return switch (selectionId) {
            case 1 -> "&0";
            case 2 -> "&1";
            case 3 -> "&2";
            case 4 -> "&3";
            case 5 -> "&4";
            case 6 -> "&5";
            case 7 -> "&6";
            case 8 -> "&7";
            case 9 -> "&8";
            case 10 -> "&9";
            case 11 -> "&a";
            case 12 -> "&b";
            case 13 -> "&c";
            case 14 -> "&d";
            case 15 -> "&e";
            case 16 -> "&f";
            default -> throw new IllegalArgumentException(String.format("Invalid selection: %s", selectionId));
        };
    }

    private List<ScrollableListItem> buildColorItems() {
        ArrayList<ScrollableListItem> list = new ArrayList<ScrollableListItem>();
        list.add(new ScrollableListItem(1, I18n.getLabel("color.black.label")));
        list.add(new ScrollableListItem(2, I18n.getLabel("color.dark-blue.label")));
        list.add(new ScrollableListItem(3, I18n.getLabel("color.dark-green.label")));
        list.add(new ScrollableListItem(4, I18n.getLabel("color.dark-aqua.label")));
        list.add(new ScrollableListItem(5, I18n.getLabel("color.dark-red.label")));
        list.add(new ScrollableListItem(6, I18n.getLabel("color.dark-purple.label")));
        list.add(new ScrollableListItem(7, I18n.getLabel("color.gold.label")));
        list.add(new ScrollableListItem(8, I18n.getLabel("color.gray.label")));
        list.add(new ScrollableListItem(9, I18n.getLabel("color.dark-gray.label")));
        list.add(new ScrollableListItem(10, I18n.getLabel("color.blue.label")));
        list.add(new ScrollableListItem(11, I18n.getLabel("color.green.label")));
        list.add(new ScrollableListItem(12, I18n.getLabel("color.aqua.label")));
        list.add(new ScrollableListItem(13, I18n.getLabel("color.red.label")));
        list.add(new ScrollableListItem(14, I18n.getLabel("color.light-purple.label")));
        list.add(new ScrollableListItem(15, I18n.getLabel("color.yellow.label")));
        list.add(new ScrollableListItem(16, I18n.getLabel("color.white.label")));
        return list;
    }

    public void m_6305_(PoseStack poseStack, int partialTick, int mouseX, float mouseY) {
        this.m_7333_(poseStack);
        NicknameBuilderScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        String currentDisplay = new NicknameChangeRequest(this.letters, this.boldSelected.get(), this.italicSelected.get()).toString();
        TextComponent currentNickname = ComponentUtil.buildColoredTextComponent(currentDisplay);
        NicknameBuilderScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)currentNickname, (int)(this.f_96543_ / 2), (int)40, (int)GuiConstants.COLOR_WHITE);
        super.m_6305_(poseStack, mouseX, mouseX, (float)partialTick);
    }
}

