/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.notification;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.notification.PlayerNotificationPage;
import com.equestricraft.core.player.notification.PlayerNotificationRecord;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.notification.PlayerNotificationWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClearAllPlayerNotificationsPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerNotificationMenuOpenRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PlayerNotificationMenuScreen
extends PageScreen<PlayerNotificationPage, PlayerNotificationRecord, Object, String> {
    private String hoursSinceHeaderLabel = "";
    private String messageHeaderLabel = "";
    private final TextComponent noNotificationsLabel = ComponentUtil.buildColoredTextComponent(I18n.getLabel("player-notifications.menu.no-notifications.label"));

    public static void showScreen(PlayerNotificationPage page) {
        PlayerNotificationMenuScreen screen = new PlayerNotificationMenuScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlayerNotificationMenuScreen(PlayerNotificationPage page) {
        super(I18n.getLabel("player-notifications.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initSearch();
        this.initTable();
        this.initSortDirectionButtons();
        this.initClearAllButton();
    }

    private void initSearch() {
        EditBox searchText = new EditBox(this.f_96547_, 5, 7, 100, 15, (Component)ComponentUtil.buildColoredTextComponent(""));
        searchText.m_94144_((String)((PlayerNotificationPage)this.page).getFilterObject());
        ECButton searchButton = ECButton.Builder.start(110, 7, 50, 15).withLabel(I18n.getLabel("player-notifications.menu.button.search.label")).withOnClick(() -> {
            String text = searchText.m_94155_();
            ServerBoundPlayerNotificationMenuOpenRequestPacket packet = new ServerBoundPlayerNotificationMenuOpenRequestPacket(((PlayerNotificationPage)this.page).getPageNumber(), ((PlayerNotificationPage)this.page).getSortDirection(), text);
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)searchText);
        this.m_142416_((GuiEventListener)searchButton);
    }

    private void initTable() {
        this.hoursSinceHeaderLabel = I18n.getLabel("player-notifications.menu.header.hours-since.label");
        this.messageHeaderLabel = I18n.getLabel("player-notifications.menu.header.message.label");
    }

    private void initSortDirectionButtons() {
        ECButton.Builder buttonBuilder = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20);
        if (((PlayerNotificationPage)this.page).getSortDirection() == SortDirection.ASCENDING) {
            buttonBuilder = buttonBuilder.withLabel(I18n.getLabel("player-notifications.menu.button.order-descending.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlayerNotificationMenuOpenRequestPacket(((PlayerNotificationPage)this.page).getPageNumber(), SortDirection.DESCENDING, (String)((PlayerNotificationPage)this.page).getFilterObject())));
        } else if (((PlayerNotificationPage)this.page).getSortDirection() == SortDirection.DESCENDING) {
            buttonBuilder = buttonBuilder.withLabel(I18n.getLabel("player-notifications.menu.button.order-ascending.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlayerNotificationMenuOpenRequestPacket(((PlayerNotificationPage)this.page).getPageNumber(), SortDirection.ASCENDING, (String)((PlayerNotificationPage)this.page).getFilterObject())));
        }
        ECButton button = buttonBuilder.complete();
        this.m_142416_((GuiEventListener)button);
    }

    private void initClearAllButton() {
        ECButton clearAllButton = ECButton.Builder.start(this.f_96543_ - 140, this.f_96544_ - 25, 100, 20).withLabel(I18n.getLabel("player-notifications.menu.button.clear-all.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClearAllPlayerNotificationsPacket())).complete();
        this.m_142416_((GuiEventListener)clearAllButton);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlayerNotificationMenuOpenRequestPacket packet = new ServerBoundPlayerNotificationMenuOpenRequestPacket(newPageNumber, ((PlayerNotificationPage)this.page).getSortDirection(), (String)((PlayerNotificationPage)this.page).getFilterObject());
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerNotificationMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        PlayerNotificationMenuScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.hoursSinceHeaderLabel, (int)20, (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        PlayerNotificationMenuScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.messageHeaderLabel, (int)100, (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        if (((PlayerNotificationPage)this.page).getItems().isEmpty()) {
            PlayerNotificationMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.noNotificationsLabel, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)GuiConstants.COLOR_WHITE);
        } else {
            int y = 50;
            for (PlayerNotificationRecord notification : ((PlayerNotificationPage)this.page).getItems()) {
                PlayerNotificationWidget widget = new PlayerNotificationWidget(20, y, this.f_96543_ - 40, 15, notification);
                widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
                int height = widget.m_93694_();
                y += height + 5;
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

