/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.operation;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.operation.OperationToolItemInfo;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class OperationToolWidget
extends ECWidget {
    private final OperationToolItemInfo operation;
    private final Consumer<OperationToolItemInfo> onClick;
    private final ECField nameField;
    private final ECField horsesField;
    private final ECField priceField;
    private final ECField paymentField;
    private final ECMultiLineField descriptionLabel;

    public OperationToolWidget(int x, int y, int width, int height, OperationToolItemInfo operation, Consumer<OperationToolItemInfo> onClick) {
        super(x, y, width, height);
        this.operation = operation;
        this.onClick = onClick;
        int currentY = 0;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withValue(operation.name()).complete();
        this.horsesField = ECField.Builder.start(this.dx(0), this.dy(currentY += 15), width).withLabel(I18n.getLabel("operation-toolbox.menu.item.field.horses-needed.label")).withValue(operation.horses()).complete();
        this.priceField = ECField.Builder.start(this.dx(0), this.dy(currentY += 15), width).withLabel(I18n.getLabel(operation.priceMayVary() ? "operation-toolbox.menu.item.field.estimated-price.label" : "operation-toolbox.menu.item.field.price.label")).withValue(operation.priceForPlayer()).complete();
        this.paymentField = ECField.Builder.start(this.dx(0), this.dy(currentY += 15), width).withLabel(I18n.getLabel("operation-toolbox.menu.item.field.payment.label")).withValue(operation.paymentToUser()).complete();
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(operation.description()).withPosition(this.dx(0), this.dy(currentY += 15)).withWidth(width).complete();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.horsesField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.priceField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.paymentField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionLabel.render(poseStack);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.operation);
        return true;
    }
}

