/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.operation;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.operation.OperationToolItemInfo;
import com.equestricraft.core.operation.OperationToolPage;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.operation.OperationToolWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundOperationSelectPacket;
import com.equestricraft.mod.packet.ServerBoundOperationToolboxRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OperationToolboxMenuScreen
extends PageScreen<OperationToolPage, OperationToolItemInfo, Object, Object> {
    public static void showScreen(OperationToolPage page) {
        OperationToolboxMenuScreen screen = new OperationToolboxMenuScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private OperationToolboxMenuScreen(OperationToolPage page) {
        super(I18n.getLabel("operation.toolbox-menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initList();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundOperationToolboxRequestPacket packet = new ServerBoundOperationToolboxRequestPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    private void initList() {
        int x = 20;
        int y = 25;
        for (OperationToolItemInfo operationItem : ((OperationToolPage)this.page).getItems()) {
            int widgetWidth = (this.f_96543_ - 40) / 2;
            OperationToolWidget widget = new OperationToolWidget(x, y, widgetWidth, 80, operationItem, this::onItemClick);
            if ((x += widgetWidth) > this.f_96543_ - 20) {
                x = 20;
                y += 85;
            }
            this.m_142416_((GuiEventListener)widget);
        }
    }

    private void onItemClick(OperationToolItemInfo operationToolItemInfo) {
        this.m_7379_();
        ServerBoundOperationSelectPacket packet = new ServerBoundOperationSelectPacket(operationToolItemInfo.id());
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        OperationToolboxMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

