/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.playersearch;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.player.search.PlayerSearchItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class PlayerSearchItemWidget
extends ECWidget {
    private final PlayerSearchItem playerSearchItem;
    private final Consumer<PlayerSearchItem> onClick;
    private final ECField ignField;
    private final ECField nicknameField;
    private final ECField onlineField;
    private final ECField starredField;

    public PlayerSearchItemWidget(int x, int y, int width, PlayerSearchItem player, Consumer<PlayerSearchItem> onClick) {
        super(x, y, width, 60);
        this.playerSearchItem = player;
        this.onClick = onClick;
        int fieldY = 0;
        this.ignField = ECField.Builder.start(this.dx(0), this.dy(fieldY), width).withValue(player.player().ign()).complete();
        fieldY += 15;
        if (player.player().hasNickname()) {
            this.nicknameField = ECField.Builder.start(this.dx(0), this.dy(fieldY), width).withValue(player.player().nickname()).complete();
            fieldY += 15;
        } else {
            this.nicknameField = null;
        }
        if (player.player().online()) {
            this.onlineField = ECField.Builder.start(this.dx(0), this.dy(fieldY), width).withValue(I18n.getLabel("prompt.player-search.menu.item.field.online.label")).withValueColor(Argb.ARGB_GREEN).complete();
            fieldY += 15;
        } else {
            this.onlineField = null;
        }
        this.starredField = player.starredBySearchingPlayer() ? ECField.Builder.start(this.dx(0), this.dy(fieldY), width).withValue(I18n.getLabel("prompt.player-search.menu.item.field.starred.label")).withValueColor(Argb.ARGB_GREEN).complete() : null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.ignField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.nicknameField != null) {
            this.nicknameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.onlineField != null) {
            this.onlineField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.starredField != null) {
            this.starredField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.onClick.accept(this.playerSearchItem);
        return true;
    }
}

