/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.playersearch;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.LoadingScreen;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.playersearch.PlayerSearchItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlayerSearchMenuRequestPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerSearchMenuSelectPacket;
import com.equestricraft.mod.player.search.PlayerSearchItem;
import com.equestricraft.mod.player.search.PlayerSearchPage;
import com.equestricraft.mod.player.search.PlayerSearchRequest;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerSearchMenuScreen
extends PageScreen<PlayerSearchPage, PlayerSearchItem, Object, PlayerSearchRequest> {
    private final UUID uuid;
    private EditBox textBox;
    private boolean sendCancel = true;

    public static void showPlayerSearchMenuScreen(UUID uuid, PlayerSearchPage page) {
        PlayerSearchMenuScreen screen = new PlayerSearchMenuScreen(uuid, page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlayerSearchMenuScreen(UUID uuid, PlayerSearchPage page) {
        super(I18n.getLabel("prompt.player-search.menu.title"), page);
        this.uuid = uuid;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initSearchComponents();
        this.initList();
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlayerSearchMenuRequestPacket packet = new ServerBoundPlayerSearchMenuRequestPacket(this.uuid, (PlayerSearchRequest)((PlayerSearchPage)this.page).getFilterObject(), newPageNumber);
        Network.sendToServer(packet);
    }

    private void initSearchComponents() {
        this.textBox = new EditBox(this.f_96547_, 20, 25, 150, 15, (Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("prompt.player-search.menu.field.search-terms.label")));
        this.m_142416_((GuiEventListener)this.textBox);
        this.m_94718_((GuiEventListener)this.textBox);
        ECButton searchButton = ECButton.Builder.start(180, 25, 70, 15).withLabel(I18n.getLabel("prompt.player-search.menu.button.search.label")).withOnClick(() -> {
            this.sendCancel = false;
            LoadingScreen.showLoadingScreen();
            PlayerSearchRequest searchRequest = new PlayerSearchRequest(this.textBox.m_94155_(), false, false);
            ServerBoundPlayerSearchMenuRequestPacket packet = new ServerBoundPlayerSearchMenuRequestPacket(this.uuid, searchRequest, ((PlayerSearchPage)this.page).getPageNumber());
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)searchButton);
    }

    private void initList() {
        int x = 10;
        int y = 45;
        int componentWidth = (this.f_96543_ - 20) / 4;
        for (PlayerSearchItem player : ((PlayerSearchPage)this.page).getItems()) {
            PlayerSearchItemWidget playerComponent = new PlayerSearchItemWidget(x, y, componentWidth, player, p -> {
                this.sendCancel = false;
                this.m_7379_();
                ServerBoundPlayerSearchMenuSelectPacket packet = new ServerBoundPlayerSearchMenuSelectPacket(this.uuid, p.player().id());
                Network.sendToServer(packet);
            });
            this.m_142416_((GuiEventListener)playerComponent);
            if ((x += componentWidth + 5) < this.f_96543_ - 20) continue;
            x = 10;
            y += 65;
        }
    }

    public void m_96624_() {
        super.m_96624_();
        this.textBox.m_94120_();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerSearchMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.sendCancel) {
            ServerBoundPlayerSearchMenuSelectPacket packet = new ServerBoundPlayerSearchMenuSelectPacket(this.uuid, null);
            Network.sendToServer(packet);
        }
    }
}

