/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.access.PlotAccessInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.plot.PlotAccessWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotAccessListMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlotGrantAccessPacket;
import com.equestricraft.mod.packet.ServerBoundPlotPromotePlayerOwnerPacket;
import com.equestricraft.mod.packet.ServerBoundPlotRevokeAccessPacket;
import com.equestricraft.mod.plot.PlotAccessPage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotAccessListMenuScreen
extends PageScreen<PlotAccessPage, PlotAccessInfo, Object, Object> {
    private final int plotId;

    public static void showScreen(int plotId, PlotAccessPage page) {
        PlotAccessListMenuScreen screen = new PlotAccessListMenuScreen(plotId, page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotAccessListMenuScreen(int plotId, PlotAccessPage page) {
        super(I18n.getLabel("plot.access-list.menu.title"), page);
        this.plotId = plotId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
        this.initButtons();
    }

    private void initItems() {
        int x = 15;
        int y = 30;
        int itemWidth = (this.f_96543_ - 30) / 4;
        for (PlotAccessInfo item : ((PlotAccessPage)this.page).getItems()) {
            PlotAccessWidget widget = new PlotAccessWidget(x, y, itemWidth, item, this::onRevoke, this::onPromoteOwner);
            if ((x += itemWidth + 5) >= this.f_96543_ - 15) {
                x = 15;
                y += 75;
            }
            this.m_142416_((GuiEventListener)widget);
        }
    }

    private void initButtons() {
        ECButton grantAccessButton = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20).withLabel(I18n.getLabel(I18n.getLabel("plot.access-list.menu.button.grant-access.label"))).withOnClick(() -> Network.sendToServer(new ServerBoundPlotGrantAccessPacket(this.plotId))).complete();
        this.m_142416_((GuiEventListener)grantAccessButton);
    }

    private void onRevoke(PlotAccessInfo info2) {
        ServerBoundPlotRevokeAccessPacket packet = new ServerBoundPlotRevokeAccessPacket(this.plotId, info2.player().id());
        Network.sendToServer(packet);
    }

    private void onPromoteOwner(PlotAccessInfo info2) {
        ServerBoundPlotPromotePlayerOwnerPacket packet = new ServerBoundPlotPromotePlayerOwnerPacket(this.plotId, info2.player().id());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlotAccessListMenuOpenPacket packet = new ServerBoundPlotAccessListMenuOpenPacket(this.plotId, newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotAccessListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

