/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.access.PlotAccessInfo;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class PlotAccessWidget
extends ECWidget {
    private final ECField ignField;
    private final ECField accessLevelField;
    private final ECButton revokeButton;
    private final ECButton promoteOwnerButton;

    protected PlotAccessWidget(int x, int y, int width, PlotAccessInfo plotAccessInfo, Consumer<PlotAccessInfo> onRevokeClick, Consumer<PlotAccessInfo> onPromoteOwnerClick) {
        super(x, y, width, 65);
        this.ignField = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("plot.access-list.menu.field.ign.label")).withValue(plotAccessInfo.player().ign()).complete();
        this.accessLevelField = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("plot.access-list.menu.field.level.label")).withValue(plotAccessInfo.accessLevel().name()).complete();
        this.revokeButton = ECButton.Builder.start(this.dx(0), this.dy(30), width, 15).withLabel(I18n.getLabel("plot.access-list.menu.button.revoke.label")).withOnClick(() -> onRevokeClick.accept(plotAccessInfo)).complete();
        this.promoteOwnerButton = ECButton.Builder.start(this.dx(0), this.dy(50), width, 15).withLabel(I18n.getLabel("plot.access-list.menu.button.promote-owner.label")).withOnClick(() -> onPromoteOwnerClick.accept(plotAccessInfo)).complete();
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.revokeButton.m_6375_(mouseX, mouseY, action) || this.promoteOwnerButton.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.ignField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.accessLevelField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.revokeButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.promoteOwnerButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

