/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.map.PlotMapItemType;
import com.equestricraft.core.plot.map.grid.PlotGridMapItem;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;

public class PlotGridNearbyMapWidget
extends ECWidget {
    private static final Argb CURRENT_PLOT_COLOR = Argb.ARGB_BLUE;
    private static final Argb OWNED_PLOT_COLOR = Argb.ARGB_GREEN;
    private static final Argb ACCESS_PLOT_COLOR = Argb.ARGB_YELLOW;
    private static final Argb NO_ACCESS_PLOT_COLOR = Argb.ARGB_RED;
    private final List<MapSquareGroup> mapItems;
    private final String currentPlotLabel = I18n.getLabel("plot.nearby-map-widget.key.current.label");
    private final String ownedPlotLabel = I18n.getLabel("plot.nearby-map-widget.key.owned.label");
    private final String accessPlotLabel = I18n.getLabel("plot.nearby-map-widget.key.access.label");
    private final String noAccessPlotLabel = I18n.getLabel("plot.nearby-map-widget.key.no-access.label");

    protected PlotGridNearbyMapWidget(int x, int y, int width, int height, List<PlotGridMapItem> mapItems) {
        super(x, y, width, height);
        this.mapItems = this.prepareItems(mapItems);
    }

    private List<MapSquareGroup> prepareItems(List<PlotGridMapItem> mapItems) {
        if (mapItems.isEmpty()) {
            return Collections.emptyList();
        }
        List<Integer> xValues = mapItems.stream().map(PlotGridMapItem::coordinates).flatMap(Collection::stream).map(PlotCoordinate::getX).sorted().toList();
        List<Integer> zValues = mapItems.stream().map(PlotGridMapItem::coordinates).flatMap(Collection::stream).map(PlotCoordinate::getZ).sorted().toList();
        int minX = xValues.get(0);
        int minZ = zValues.get(0);
        return mapItems.stream().map(p -> new MapSquareGroup(p.plotId(), p.coordinates().stream().map(c -> new MapSquareGroup.MapSquare((c.getX() - minX) * 15 + 7, (c.getZ() - minZ) * 15 + 7)).toList(), this.determineColor((PlotGridMapItem)p))).toList();
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderAreas(poseStack);
        this.renderKey(poseStack);
    }

    private void renderAreas(PoseStack poseStack) {
        for (MapSquareGroup plotItem : this.mapItems) {
            for (MapSquareGroup.MapSquare square : plotItem.mapSquares) {
                PlotGridNearbyMapWidget.m_93172_((PoseStack)poseStack, (int)this.dx(square.x() - 7), (int)this.dy(square.y() - 7), (int)this.dx(square.x() + 7), (int)this.dy(square.y() + 7), (int)plotItem.color().getIntValue());
            }
        }
    }

    private Argb determineColor(PlotGridMapItem item) {
        return switch (item.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PlotMapItemType.OWNED_PLOT -> OWNED_PLOT_COLOR;
            case PlotMapItemType.ACCESS_PLOT -> ACCESS_PLOT_COLOR;
            case PlotMapItemType.NO_ACCESS_PLOT -> NO_ACCESS_PLOT_COLOR;
            case PlotMapItemType.CURRENT_PLOT -> CURRENT_PLOT_COLOR;
        };
    }

    private void renderKey(PoseStack poseStack) {
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 85), this.dy(5), 10, 10, CURRENT_PLOT_COLOR);
        PlotGridNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.currentPlotLabel, (int)this.dx(this.f_93618_ - 70), (int)this.dy(5), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 85), this.dy(25), 10, 10, OWNED_PLOT_COLOR);
        PlotGridNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.ownedPlotLabel, (int)this.dx(this.f_93618_ - 70), (int)this.dy(25), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 85), this.dy(45), 10, 10, ACCESS_PLOT_COLOR);
        PlotGridNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.accessPlotLabel, (int)this.dx(this.f_93618_ - 70), (int)this.dy(45), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 85), this.dy(65), 10, 10, NO_ACCESS_PLOT_COLOR);
        PlotGridNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.noAccessPlotLabel, (int)this.dx(this.f_93618_ - 70), (int)this.dy(65), (int)GuiConstants.COLOR_WHITE);
    }

    private record MapSquareGroup(int id, List<MapSquare> mapSquares, Argb color) {

        private record MapSquare(int x, int y) {
        }
    }
}

