/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotGridPurchasePacket;
import com.equestricraft.mod.packet.ServerBoundPlotPurchaseRandomNameRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotGridPurchaseScreen
extends Screen {
    private static PlotGridPurchaseScreen screen = null;
    private final DirectionalCoordinate coordinate;
    private ECTextField nameField = null;

    public static void showScreen(DirectionalCoordinate coordinate) {
        screen = new PlotGridPurchaseScreen(coordinate);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public static void setName(String name) {
        PlotGridPurchaseScreen.screen.nameField.setValue(name);
    }

    public PlotGridPurchaseScreen(DirectionalCoordinate coordinate) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("plot.grid.purchase.menu.title")));
        this.coordinate = coordinate;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.nameField = ECTextField.Builder.start(10, 20, this.f_96543_ - 20).withLabel(I18n.getLabel("plot.grid.purchase.menu.field.name.label")).complete();
        ECButton randomNameButton = ECButton.Builder.start(this.f_96543_ / 2, 40, 150, 20).withLabel(I18n.getLabel("plot.grid.purchase.menu.button.random-name.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlotPurchaseRandomNameRequestPacket())).centerAligned().complete();
        ECButton purchaseButton = ECButton.Builder.start(this.f_96543_ / 2, this.f_96544_ - 50, 100, 15).withLabel(I18n.getLabel("plot.grid.purchase.menu.button.purchase.label")).withOnClick(() -> {
            this.m_7379_();
            String name = this.nameField.getValue();
            ServerBoundPlotGridPurchasePacket packet = new ServerBoundPlotGridPurchasePacket(this.coordinate, name);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)this.nameField);
        this.m_142416_((GuiEventListener)randomNameButton);
        this.m_142416_((GuiEventListener)purchaseButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotGridPurchaseScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

