/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlotTeleportPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class PlotListItemWidget
extends ECWidget {
    private final PlotInfo plotInfo;
    private final Consumer<PlotInfo> onSelect;
    private final ECField nameField;
    private final ECField typeField;
    private final ECButton viewButton;
    private final ECButton goToButton;

    protected PlotListItemWidget(int x, int y, int width, PlotInfo plotInfo) {
        this(x, y, width, plotInfo, null);
        this.setHeight(GuiUtil.getSpacedLineHeight());
    }

    protected PlotListItemWidget(int x, int y, int width, PlotInfo plotInfo, Consumer<PlotInfo> onSelect) {
        super(x, y, width, 50);
        this.plotInfo = plotInfo;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(plotInfo.name()).complete();
        this.typeField = FeatureFlag.NATURAL_PLOTS.isEnabled() ? ECField.Builder.start(this.dx(width - 100), this.dy(0), width).withValue(plotInfo.type().name()).complete() : null;
        if (onSelect != null) {
            this.viewButton = null;
            this.goToButton = null;
            this.onSelect = onSelect;
        } else {
            this.viewButton = ECButton.Builder.start(this.dx(width - 60), this.dy(0), 30, GuiUtil.getSpacedLineHeight()).withLabel(I18n.getLabel("plot.list.menu.button.view.label")).withOnClick(this::onViewClick).complete();
            this.goToButton = ECButton.Builder.start(this.dx(width - 30), this.dy(0), 30, GuiUtil.getSpacedLineHeight()).withLabel(I18n.getLabel("plot.list.menu.button.go-to.label")).withOnClick(this::onTpClick).complete();
            this.onSelect = null;
        }
    }

    private void onViewClick() {
        ServerBoundPlotMenuOpenPacket packet = new ServerBoundPlotMenuOpenPacket(this.plotInfo.id());
        Network.sendToServer(packet);
    }

    private void onTpClick() {
        ServerBoundPlotTeleportPacket packet = new ServerBoundPlotTeleportPacket(this.plotInfo.id());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.typeField != null) {
            this.typeField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.viewButton != null) {
            this.viewButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.goToButton != null) {
            this.goToButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.onSelect != null) {
            this.onSelect.accept(this.plotInfo);
            return true;
        }
        return this.viewButton.m_6375_(mouseX, mouseY, action) || this.goToButton.m_6375_(mouseX, mouseY, action);
    }
}

