/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.plot.PlotListItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotListMenuOpenPacket;
import com.equestricraft.mod.plot.PlotPage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotListMenuScreen
extends PageScreen<PlotPage, PlotInfo, Object, Object> {
    public static void showScreen(PlotPage page) {
        PlotListMenuScreen screen = new PlotListMenuScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotListMenuScreen(PlotPage page) {
        super(I18n.getLabel("plot.list.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
    }

    private void initItems() {
        int y = 30;
        for (PlotInfo item : ((PlotPage)this.page).getItems()) {
            PlotListItemWidget widget = new PlotListItemWidget(15, y, this.f_96543_ - 30, item);
            y += widget.m_93694_();
            this.m_142416_((GuiEventListener)widget);
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlotListMenuOpenPacket packet = new ServerBoundPlotListMenuOpenPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

