/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotAccessListMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlotRenamePacket;
import com.equestricraft.mod.packet.ServerBoundPlotStartSellPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotMenu
extends Screen {
    private final PlotInfo plotInfo;

    public static void showScreen(PlotInfo plotInfo) {
        PlotMenu screen = new PlotMenu(plotInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotMenu(PlotInfo plotInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(plotInfo.name()));
        this.plotInfo = plotInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECButton renameButton = ECButton.Builder.start(this.f_96543_ / 2, 50, 100, 20).withLabel(I18n.getLabel("plot.menu.button.rename.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlotRenamePacket(this.plotInfo.id()))).centerAligned().complete();
        ECButton manageAccessButton = ECButton.Builder.start(this.f_96543_ / 2, 75, 100, 20).withLabel(I18n.getLabel("plot.menu.button.manage-access.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlotAccessListMenuOpenPacket(this.plotInfo.id(), 1))).centerAligned().complete();
        ECButton sellButton = ECButton.Builder.start(this.f_96543_ / 2, 100, 100, 20).withLabel(I18n.getLabel("plot.menu.button.sell.label")).withOnClick(() -> Network.sendToServer(new ServerBoundPlotStartSellPacket(this.plotInfo.id()))).centerAligned().complete();
        this.m_142416_((GuiEventListener)renameButton);
        this.m_142416_((GuiEventListener)manageAccessButton);
        this.m_142416_((GuiEventListener)sellButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

