/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.plot.PlotListItemWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotMergeSelectPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlotMergeScreen
extends Screen {
    private final PlotInfo targetPlot;
    private final List<PlotInfo> plots;

    public static void showScreen(PlotInfo targetPlot, List<PlotInfo> plots) {
        PlotMergeScreen screen = new PlotMergeScreen(targetPlot, plots);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotMergeScreen(PlotInfo targetPlot, List<PlotInfo> plots) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("plot.merge.title")));
        this.targetPlot = targetPlot;
        this.plots = plots;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
    }

    private void initItems() {
        int x = 15;
        int y = 30;
        int itemWidth = (this.f_96543_ - 30) / 4;
        for (PlotInfo item : this.plots) {
            PlotListItemWidget widget = new PlotListItemWidget(x, y, itemWidth, item, this::onSelect);
            y += 15;
            this.m_142416_((GuiEventListener)widget);
        }
    }

    private void onSelect(PlotInfo plotInfo) {
        ServerBoundPlotMergeSelectPacket packet = new ServerBoundPlotMergeSelectPacket(this.targetPlot.id(), plotInfo.id());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotMergeScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

