/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.Argb;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotNearbyAreaMapItem;
import com.equestricraft.core.plot.PlotNearbyAreaType;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;

public class PlotNaturalNearbyMapWidget
extends ECWidget {
    private static final Argb TARGET_AREA_COLOR = Argb.ARGB_GREEN;
    private static final Argb OTHER_PLOTS_COLOR = Argb.ARGB_YELLOW;
    private static final Argb SPAWN_AREA_COLOR = Argb.ARGB_PINK;
    private static final Argb CONFLICT_AREA_COLOR = Argb.ARGB_RED;
    private List<PlotNearbyAreaMapItem> plotItems;
    private final String targetAreaKey = I18n.getLabel("plot.natural.nearby-map-widget.key.target-area.label");
    private final String otherPlotsKey = I18n.getLabel("plot.natural.nearby-map-widget.key.other-plot.label");
    private final String spawnKey = I18n.getLabel("plot.natural.nearby-map-widget.key.spawn.label");
    private final String conflictAreaKey = I18n.getLabel("plot.natural.nearby-map-widget.key.conflict-area.label");

    public PlotNaturalNearbyMapWidget(int x, int y, int width, int height, List<PlotNearbyAreaMapItem> plotItems) {
        super(x, y, width, height);
        this.plotItems = this.prepareItems(plotItems);
    }

    public void setPlotItems(List<PlotNearbyAreaMapItem> plotItems) {
        this.plotItems = this.prepareItems(plotItems);
    }

    private List<PlotNearbyAreaMapItem> prepareItems(List<PlotNearbyAreaMapItem> plotItems) {
        if (plotItems.isEmpty()) {
            return plotItems;
        }
        Area2D enclosingArea = this.buildEnclosingArea(plotItems);
        int xOffset = -enclosingArea.x1();
        int zOffset = -enclosingArea.z1();
        float scaleFactor = enclosingArea.x2() > enclosingArea.z2() ? (float)((double)this.f_93618_ - 80.0 / (double)(enclosingArea.x2() + xOffset)) : (float)((double)this.f_93619_ / (double)(enclosingArea.z2() + zOffset));
        return plotItems.stream().map(p -> {
            List<Area2D> newAreas = p.areas().stream().map(a -> a.shiftX(xOffset).shiftZ(zOffset)).map(a -> a.transformScale(scaleFactor)).toList();
            return new PlotNearbyAreaMapItem(newAreas, p.type(), p.hasOverlap());
        }).toList();
    }

    private Area2D buildEnclosingArea(List<PlotNearbyAreaMapItem> plotItems) {
        List allAreas = plotItems.stream().flatMap(p -> p.areas().stream()).toList();
        if (allAreas.isEmpty()) {
            throw new IllegalArgumentException("No areas provided");
        }
        Integer left = null;
        Integer right = null;
        Integer top = null;
        Integer bottom = null;
        for (Area2D area : allAreas) {
            if (left == null || area.x1() < left) {
                left = area.x1();
            }
            if (top == null || area.z1() < top) {
                top = area.z1();
            }
            if (right == null || area.x2() > right) {
                right = area.x2();
            }
            if (bottom != null && area.z2() <= bottom) continue;
            bottom = area.z2();
        }
        return new Area2D(left, right, top, bottom);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderAreas(poseStack);
        this.renderKey(poseStack);
    }

    private void renderAreas(PoseStack poseStack) {
        for (PlotNearbyAreaMapItem plotItem : this.plotItems) {
            Argb color = this.determineColor(plotItem);
            for (Area2D area : plotItem.areas()) {
                PlotNaturalNearbyMapWidget.m_93172_((PoseStack)poseStack, (int)this.dx(area.x1()), (int)this.dy(area.z1()), (int)this.dx(area.x2()), (int)this.dy(area.z2()), (int)color.getIntValue());
            }
        }
    }

    private void renderKey(PoseStack poseStack) {
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 75), this.dy(5), 10, 10, TARGET_AREA_COLOR);
        PlotNaturalNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.targetAreaKey, (int)this.dx(this.f_93618_ - 60), (int)this.dy(5), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 75), this.dy(25), 10, 10, OTHER_PLOTS_COLOR);
        PlotNaturalNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.otherPlotsKey, (int)this.dx(this.f_93618_ - 60), (int)this.dy(25), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 75), this.dy(45), 10, 10, SPAWN_AREA_COLOR);
        PlotNaturalNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.spawnKey, (int)this.dx(this.f_93618_ - 60), (int)this.dy(45), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 75), this.dy(65), 10, 10, CONFLICT_AREA_COLOR);
        PlotNaturalNearbyMapWidget.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.conflictAreaKey, (int)this.dx(this.f_93618_ - 60), (int)this.dy(65), (int)GuiConstants.COLOR_WHITE);
    }

    private Argb determineColor(PlotNearbyAreaMapItem item) {
        if (item.hasOverlap()) {
            return CONFLICT_AREA_COLOR;
        }
        return switch (item.type()) {
            default -> throw new IncompatibleClassChangeError();
            case PlotNearbyAreaType.TARGET -> TARGET_AREA_COLOR;
            case PlotNearbyAreaType.PLOT -> OTHER_PLOTS_COLOR;
            case PlotNearbyAreaType.SPAWN -> SPAWN_AREA_COLOR;
        };
    }
}

