/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.PlotNearbyAreaMapItem;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECNumberSpinner;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.plot.PlotNaturalNearbyMapWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotNaturalPurchasePacket;
import com.equestricraft.mod.packet.ServerBoundPlotNearbyAreasUpdatePacket;
import com.equestricraft.mod.packet.ServerBoundPlotPriceCalculationPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotNaturalPurchaseScreen
extends Screen {
    private static PlotNaturalPurchaseScreen screen = null;
    private final DirectionalCoordinate coordinate;
    private final int minimumRadius;
    private ECField dimensionField;
    private ECField priceField;
    private PlotNaturalNearbyMapWidget mapWidget;

    public static void showScreen(DirectionalCoordinate coordinate, int minimumRadius) {
        screen = new PlotNaturalPurchaseScreen(coordinate, minimumRadius);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public static void updatePrice(String price) {
        if (screen != null) {
            PlotNaturalPurchaseScreen.screen.priceField.setValue(price);
        }
    }

    public static void updateMap(List<PlotNearbyAreaMapItem> items) {
        if (screen != null) {
            PlotNaturalPurchaseScreen.screen.mapWidget.setPlotItems(items);
        }
    }

    public PlotNaturalPurchaseScreen(DirectionalCoordinate coordinate, int minimumRadius) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("plot.natural.purchase.menu.title")));
        this.coordinate = coordinate;
        this.minimumRadius = minimumRadius;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField nameField = ECTextField.Builder.start(10, 20, this.f_96543_ - 20).withLabel(I18n.getLabel("plot.natural.purchase.menu.field.name.label")).complete();
        ECNumberSpinner radiusField = ECNumberSpinner.Builder.start(40, 50).withLabel(I18n.getLabel("plot.natural.purchase.menu.field.radius.label")).withMinValue(this.minimumRadius).withInitialValue(this.minimumRadius).complete();
        radiusField.onValueChange(this::onRadiusChange);
        int dimension = this.calculateDimension(this.minimumRadius);
        this.dimensionField = ECField.Builder.start(10, 75, this.f_96543_ - 20).withLabel(I18n.getLabel("plot.natural.purchase.menu.field.dimension.label")).withValue(dimension + "x" + dimension).complete();
        this.priceField = ECField.Builder.start(10, 95, this.f_96543_ - 20).withLabel(I18n.getLabel("plot.natural.purchase.menu.field.price.label")).withValue("---").complete();
        this.mapWidget = new PlotNaturalNearbyMapWidget(10, 115, this.f_96543_ - 20, this.f_96544_ - 130, Collections.emptyList());
        ECButton confirmButton = ECButton.Builder.start(this.f_96543_ / 2, this.f_96544_ - 20, 100, 15).withLabel(I18n.getLabel("plot.natural.purchase.menu.button.purchase.label")).withOnClick(() -> {
            this.m_7379_();
            String name = nameField.getValue();
            int radius = radiusField.getValue();
            ServerBoundPlotNaturalPurchasePacket packet = new ServerBoundPlotNaturalPurchasePacket(this.coordinate, name, radius);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)nameField);
        this.m_142416_((GuiEventListener)radiusField);
        this.m_142416_((GuiEventListener)this.dimensionField);
        this.m_142416_((GuiEventListener)this.priceField);
        this.m_142416_((GuiEventListener)confirmButton);
        this.m_142416_((GuiEventListener)this.mapWidget);
        this.onRadiusChange(this.minimumRadius);
    }

    private void onRadiusChange(int radius) {
        this.requestPriceUpdate(radius);
        this.requestMapUpdate(radius);
        this.updateDimensionField(radius);
    }

    private void requestPriceUpdate(int radius) {
        ServerBoundPlotPriceCalculationPacket packet = new ServerBoundPlotPriceCalculationPacket(radius);
        Network.sendToServer(packet);
    }

    private void requestMapUpdate(int radius) {
        ServerBoundPlotNearbyAreasUpdatePacket packet = new ServerBoundPlotNearbyAreasUpdatePacket((int)this.coordinate.x(), (int)this.coordinate.z(), radius);
        Network.sendToServer(packet);
    }

    private void updateDimensionField(int radius) {
        int dimension = this.calculateDimension(radius);
        this.dimensionField.setValue(dimension + "x" + dimension);
    }

    private int calculateDimension(int radius) {
        return radius * 2 + 1;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotNaturalPurchaseScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

