/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.approval.PlotPendingApprovalInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PlotPendingApprovalWidget
extends ECWidget {
    private final TextComponent lineText;
    private final ECButton acceptButton;
    private final ECButton cancelButton;

    protected PlotPendingApprovalWidget(int x, int y, int width, PlotPendingApprovalInfo pendingApprovalInfo, Consumer<PlotPendingApprovalInfo> onAccept, Consumer<PlotPendingApprovalInfo> onCancel) {
        super(x, y, width, 15);
        this.lineText = ComponentUtil.buildColoredTextComponent(pendingApprovalInfo.plotName() + " - " + pendingApprovalInfo.actionType().getTranslatedName());
        this.acceptButton = pendingApprovalInfo.approvalGiven() ? null : ECButton.Builder.start(this.dx(width - 165), this.dy(0), 80, 12).withLabel(I18n.getLabel("plot.pending-approvals.menu.button.accept.label")).withOnClick(() -> onAccept.accept(pendingApprovalInfo)).complete();
        this.cancelButton = ECButton.Builder.start(this.dx(width - 80), this.dy(0), 80, 12).withLabel(I18n.getLabel("plot.pending-approvals.menu.button.cancel.label")).withOnClick(() -> onCancel.accept(pendingApprovalInfo)).complete();
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.acceptButton != null && this.acceptButton.m_6375_(mouseX, mouseY, action) || this.cancelButton.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        PlotPendingApprovalWidget.m_93243_((PoseStack)poseStack, (Font)this.getFont(), (Component)this.lineText, (int)this.dx(0), (int)this.dy(0), (int)GuiConstants.COLOR_WHITE);
        if (this.acceptButton != null) {
            this.acceptButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.cancelButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

