/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.plot.approval.PlotPendingApprovalInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.plot.PlotPendingApprovalWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotApprovalAcceptPacket;
import com.equestricraft.mod.packet.ServerBoundPlotApprovalCancelPacket;
import com.equestricraft.mod.packet.ServerBoundPlotPendingApprovalsRequestPacket;
import com.equestricraft.mod.plot.PlotPendingApprovalsPage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotPendingApprovalsScreen
extends PageScreen<PlotPendingApprovalsPage, PlotPendingApprovalInfo, Object, Object> {
    public static void showScreen(PlotPendingApprovalsPage page) {
        PlotPendingApprovalsScreen screen = new PlotPendingApprovalsScreen(page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotPendingApprovalsScreen(PlotPendingApprovalsPage page) {
        super(I18n.getLabel("plot.pending-approvals.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
    }

    private void initItems() {
        int x = 10;
        int y = 20;
        int widgetWidth = this.f_96543_ - 20;
        for (PlotPendingApprovalInfo item : ((PlotPendingApprovalsPage)this.page).getItems()) {
            PlotPendingApprovalWidget widget = new PlotPendingApprovalWidget(x, y, widgetWidth, item, this::onAccept, this::onCancel);
            y += 20;
            this.m_142416_((GuiEventListener)widget);
        }
    }

    private void onAccept(PlotPendingApprovalInfo pendingApprovalInfo) {
        this.m_7379_();
        ServerBoundPlotApprovalAcceptPacket packet = new ServerBoundPlotApprovalAcceptPacket(pendingApprovalInfo.plotId(), pendingApprovalInfo.actionType());
        Network.sendToServer(packet);
    }

    private void onCancel(PlotPendingApprovalInfo pendingApprovalInfo) {
        this.m_7379_();
        ServerBoundPlotApprovalCancelPacket packet = new ServerBoundPlotApprovalCancelPacket(pendingApprovalInfo.plotId(), pendingApprovalInfo.actionType());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundPlotPendingApprovalsRequestPacket packet = new ServerBoundPlotPendingApprovalsRequestPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotPendingApprovalsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

