/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.plot;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECNumberSpinner;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlotSellPacket;
import com.equestricraft.mod.plot.PlotSellInfo;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlotSellMenu
extends Screen {
    private final PlotSellInfo plotSellInfo;

    public static void showScreen(PlotSellInfo plotSellInfo) {
        PlotSellMenu screen = new PlotSellMenu(plotSellInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PlotSellMenu(PlotSellInfo plotSellInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("plot.sell.menu.title", plotSellInfo.plotName())));
        this.plotSellInfo = plotSellInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField playerField = ECField.Builder.start(10, 20, this.f_96543_ - 20).withLabel(I18n.getLabel("plot.sell.menu.field.player.label")).withValue(this.plotSellInfo.toPlayer().ign()).complete();
        ECNumberSpinner priceSpinner = ECNumberSpinner.Builder.start(10, 50).withLabel(I18n.getLabel("plot.sell.menu.field.price.label")).withInitialValue(0).withMinValue(0).complete();
        ECButton sellButton = ECButton.Builder.start(this.f_96543_ / 2, 80, 100, 20).withLabel(I18n.getLabel("plot.sell.menu.button.sell.label")).withOnClick(() -> {
            this.m_7379_();
            double price = priceSpinner.getValue();
            ServerBoundPlotSellPacket packet = new ServerBoundPlotSellPacket(this.plotSellInfo.plotId(), this.plotSellInfo.toPlayer().id(), price);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)playerField);
        this.m_142416_((GuiEventListener)priceSpinner);
        this.m_142416_((GuiEventListener)sellButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlotSellMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

