/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.prescription;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.components.ScrollableList;
import com.equestricraft.mod.client.gui.components.ScrollableListItem;
import com.equestricraft.mod.horse.prescription.PrescriptionMedicineItem;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPrescriptionSendPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PrescriptionGiveMenu
extends Screen {
    private final int horseId;
    private final String horseName;
    private final int illnessId;
    private final String illnessName;
    private final List<PrescriptionMedicineItem> medicineItems;

    public static void showScreen(int horseId, String horseName, int illnessId, String illnessName, List<PrescriptionMedicineItem> medicineItems) {
        PrescriptionGiveMenu menu = new PrescriptionGiveMenu(horseId, horseName, illnessId, illnessName, medicineItems);
        Minecraft.m_91087_().m_91152_((Screen)menu);
    }

    protected PrescriptionGiveMenu(int horseId, String horseName, int illnessId, String illnessName, List<PrescriptionMedicineItem> medicineItems) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("prescription.give.menu.title")));
        this.horseId = horseId;
        this.horseName = horseName;
        this.illnessId = illnessId;
        this.illnessName = illnessName;
        this.medicineItems = medicineItems;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField horseField = ECField.Builder.start(10, 20, this.f_96543_ - 20).withLabel(I18n.getLabel("prescription.give.menu.field.horse.label")).withValue(this.horseName).complete();
        ECField illnessField = ECField.Builder.start(10, 35, this.f_96543_ - 20).withLabel(I18n.getLabel("prescription.give.menu.field.illness.label")).withValue(this.illnessName).complete();
        ECTextField descriptionField = ECTextField.Builder.start(10, 50, this.f_96543_ - 20).withLabel(I18n.getLabel("prescription.give.menu.field.enter-details.label")).complete();
        List<ScrollableListItem> medicines = this.medicineItems.stream().map(m -> new ScrollableListItem(m.medicineId(), m.medicineName())).toList();
        ScrollableList medicinesList = new ScrollableList(10, 75, this.f_96543_ - 20, 20, medicines, medicines.size());
        ECButton button = ECButton.Builder.start(10, this.f_96544_ - 40, 150, 20).withLabel(I18n.getLabel("prescription.give.menu.button.send.label")).withOnClick(() -> {
            this.m_7379_();
            String description = descriptionField.getValue();
            List<Integer> selectedMedicines = medicinesList.getSelected();
            ServerBoundPrescriptionSendPacket packet = new ServerBoundPrescriptionSendPacket(this.horseId, this.illnessId, description, selectedMedicines);
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)horseField);
        this.m_142416_((GuiEventListener)illnessField);
        this.m_142416_((GuiEventListener)descriptionField);
        this.m_142416_((GuiEventListener)medicinesList);
        this.m_142416_((GuiEventListener)button);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

